/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.keyboard.view;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public class SelectedDrawable
extends Drawable {
    protected float mRadius;
    protected Rect mRect = new Rect();
    protected Position mPosition = Position.FIRST;
    protected final Paint mPaint = new Paint(5);
    protected final Path mPath = new Path();
    protected final RectF mPathRectF = new RectF();

    public SelectedDrawable() {
        this.mPaint.setStyle(Paint.Style.STROKE);
    }

    public void setRadius(float radius) {
        this.mRadius = radius;
    }

    public void setWidth(float width) {
        this.mPaint.setStrokeWidth(width);
    }

    public Rect getRect() {
        return this.mRect;
    }

    public void setPosition(@NonNull Position position) {
        this.mPosition = position;
    }

    public void setColor(int color2) {
        this.mPaint.setColor(color2);
    }

    public void draw(@NonNull Canvas canvas) {
        float strokeWidthOffset = this.mPaint.getStrokeWidth() / 2.0f;
        int left = this.mRect.left;
        int top = this.mRect.top + (int)strokeWidthOffset;
        int right = this.mRect.right;
        int bottom = this.mRect.bottom - (int)strokeWidthOffset;
        float[] radiusArray = new float[8];
        if (this.mPosition == Position.FIRST) {
            left = (int)((float)left + strokeWidthOffset);
            radiusArray[0] = this.mRadius;
            radiusArray[1] = this.mRadius;
            radiusArray[6] = this.mRadius;
            radiusArray[7] = this.mRadius;
        } else if (this.mPosition == Position.LAST) {
            right = (int)((float)right - strokeWidthOffset);
            radiusArray[2] = this.mRadius;
            radiusArray[3] = this.mRadius;
            radiusArray[4] = this.mRadius;
            radiusArray[5] = this.mRadius;
        }
        this.mPath.reset();
        this.mPathRectF.set((float)left, (float)top, (float)right, (float)bottom);
        this.mPath.addRoundRect(this.mPathRectF, radiusArray, Path.Direction.CW);
        canvas.drawPath(this.mPath, this.mPaint);
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return 0;
    }

    static enum Position {
        FIRST,
        MIDDLE,
        LAST;

    }
}

