/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.keyboard.engine;

import com.parkingwang.keyboard.engine.KeyEntry;
import com.parkingwang.keyboard.engine.KeyType;
import com.parkingwang.keyboard.engine.RowEntry;
import java.util.Arrays;

class Utils {
    private Utils() {
    }

    static RowEntry append(RowEntry ... items) {
        RowEntry output = new RowEntry();
        for (RowEntry s : items) {
            output.addAll(s);
        }
        return output;
    }

    static RowEntry mkEntitiesOf(String keysStr) {
        RowEntry keys = new RowEntry();
        for (int i = 0; i < keysStr.length(); ++i) {
            String keyChar = String.valueOf(keysStr.charAt(i));
            keys.add(Utils.mkEntry(keyChar));
        }
        return keys;
    }

    static KeyEntry mkEntry(String text) {
        KeyType keyType;
        switch (text) {
            case "-": {
                keyType = KeyType.FUNC_DELETE;
                break;
            }
            case "+": {
                keyType = KeyType.FUNC_OK;
                break;
            }
            case ">": {
                keyType = KeyType.FUNC_MORE;
                break;
            }
            case "<": {
                keyType = KeyType.FUNC_BACK;
                break;
            }
            default: {
                keyType = KeyType.GENERAL;
            }
        }
        return new KeyEntry(text, keyType, false);
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static int hash(Object ... values) {
        return Arrays.hashCode(values);
    }
}

