/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.keyboard;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.ColorStateList;
import android.support.annotation.ColorInt;
import android.view.Window;
import com.parkingwang.keyboard.KeyboardInputController;
import com.parkingwang.keyboard.PopupHelper;
import com.parkingwang.keyboard.engine.KeyboardEngine;
import com.parkingwang.keyboard.view.InputView;
import com.parkingwang.keyboard.view.KeyboardView;

public class PopupKeyboard {
    private final KeyboardView mKeyboardView;
    private KeyboardInputController mController;
    private boolean isDialog = false;

    public PopupKeyboard(Context context) {
        this.mKeyboardView = new KeyboardView(context);
    }

    public PopupKeyboard(Context context, @ColorInt int bubbleTextColor, ColorStateList okKeyBackgroundColor) {
        this.mKeyboardView = new KeyboardView(context);
        this.mKeyboardView.setBubbleTextColor(bubbleTextColor);
        this.mKeyboardView.setOkKeyTintColor(okKeyBackgroundColor);
    }

    public KeyboardView getKeyboardView() {
        return this.mKeyboardView;
    }

    public void attach(InputView inputView, Activity activity) {
        this.isDialog = false;
        this.attach(inputView, activity.getWindow());
    }

    public void attach(InputView inputView, Dialog dialog) {
        this.isDialog = true;
        this.attach(inputView, dialog.getWindow());
    }

    private void attach(InputView inputView, final Window window) {
        if (this.mController == null) {
            this.mController = KeyboardInputController.with(this.mKeyboardView, inputView);
            this.mController.useDefaultMessageHandler();
            inputView.addOnFieldViewSelectedListener(new InputView.OnFieldViewSelectedListener(){

                @Override
                public void onSelectedAt(int index) {
                    PopupKeyboard.this.show(window);
                }
            });
        }
    }

    public KeyboardInputController getController() {
        return this.checkAttachedController();
    }

    public KeyboardEngine getKeyboardEngine() {
        return this.mKeyboardView.getKeyboardEngine();
    }

    public void show(Activity activity) {
        this.show(activity.getWindow());
    }

    public void show(Window window) {
        this.checkAttachedController();
        PopupHelper.showToWindow(window, this.mKeyboardView, this.isDialog);
    }

    public void dismiss(Activity activity) {
        this.dismiss(activity.getWindow());
    }

    public void dismiss(Window window) {
        this.checkAttachedController();
        PopupHelper.dismissFromWindow(window);
    }

    public boolean isShown() {
        return this.mKeyboardView.isShown();
    }

    private KeyboardInputController checkAttachedController() {
        if (this.mController == null) {
            throw new IllegalStateException("Try attach() first");
        }
        return this.mController;
    }
}

