/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.keyboard;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.FrameLayout;
import com.parkingwang.keyboard.view.KeyboardView;
import com.parkingwang.vehiclekeyboard.R;

public class PopupHelper {
    public static boolean showToActivity(Activity activity, KeyboardView keyboardView) {
        return PopupHelper.showToWindow(activity.getWindow(), keyboardView, false);
    }

    public static boolean showToWindow(Window window, KeyboardView keyboardView) {
        return PopupHelper.showToWindow(window, keyboardView, false);
    }

    public static boolean showToWindow(Window window, KeyboardView keyboardView, boolean belowFirstView) {
        View rootView = window.getDecorView().findViewById(0x1020002);
        FrameLayout keyboardWrapper = (FrameLayout)rootView.findViewById(R.id.keyboard_wrapper_id);
        if (keyboardWrapper == null) {
            ViewParent keyboardViewParent = keyboardView.getParent();
            if (keyboardViewParent != null && ((View)keyboardViewParent).getId() == R.id.keyboard_wrapper_id && keyboardViewParent instanceof FrameLayout) {
                keyboardWrapper = (FrameLayout)keyboardViewParent;
                PopupHelper.makeSureHasNoParent((View)keyboardWrapper);
            }
            if (keyboardWrapper == null) {
                keyboardWrapper = PopupHelper.wrapKeyboardView(keyboardView.getContext(), keyboardView);
            }
            if (rootView instanceof FrameLayout) {
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
                params.gravity = 80;
                if (belowFirstView) {
                    params.topMargin = ((ViewGroup)rootView).getChildAt(0).getHeight();
                }
                ((ViewGroup)rootView).addView((View)keyboardWrapper, (ViewGroup.LayoutParams)params);
            }
            return true;
        }
        keyboardWrapper.setVisibility(0);
        keyboardWrapper.bringToFront();
        return false;
    }

    @NonNull
    private static FrameLayout wrapKeyboardView(Context context, KeyboardView keyboardView) {
        FrameLayout keyboardWrapper = new FrameLayout(context);
        keyboardWrapper.setId(R.id.keyboard_wrapper_id);
        keyboardWrapper.setClipChildren(false);
        FrameLayout.LayoutParams keyboardParams = new FrameLayout.LayoutParams(-1, -2, 80);
        keyboardWrapper.addView((View)keyboardView, (ViewGroup.LayoutParams)keyboardParams);
        return keyboardWrapper;
    }

    private static void makeSureHasNoParent(View view) {
        if (view.getParent() != null) {
            ((ViewGroup)view.getParent()).removeView(view);
        }
    }

    public static boolean dismissFromActivity(Activity activity) {
        return PopupHelper.dismissFromWindow(activity.getWindow());
    }

    public static boolean dismissFromWindow(Window window) {
        View view = window.getDecorView().findViewById(R.id.keyboard_wrapper_id);
        if (view == null) {
            return false;
        }
        ((ViewGroup)view.getParent()).removeView(view);
        return true;
    }
}

