/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.keyboard.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.TextView;
import com.parkingwang.keyboard.engine.KeyEntry;
import com.parkingwang.keyboard.engine.KeyType;
import com.parkingwang.keyboard.view.BubbleDrawable;
import com.parkingwang.keyboard.view.DrawableTint;
import com.parkingwang.vehiclekeyboard.R;

final class KeyView
extends TextView {
    private final BubbleDrawable mBubbleDrawable;
    private KeyEntry mBoundKey;
    private Drawable mDeleteDrawable;
    private boolean mDrawPressedText = false;
    private boolean mShowBubble;
    private ColorStateList mOkKeyTintColor;

    public KeyView(Context context) {
        this(context, null);
    }

    public KeyView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setPadding(0, 0, 0, 0);
        this.setGravity(17);
        this.mBubbleDrawable = new BubbleDrawable(context);
        this.mOkKeyTintColor = ContextCompat.getColorStateList((Context)this.getContext(), (int)R.color.pwk_keyboard_key_ok_tint_color);
    }

    public void setBubbleTextColor(int bubbleTextColor) {
        this.mBubbleDrawable.setTextColor(bubbleTextColor);
    }

    public void setOkKeyTintColor(ColorStateList okKeyTintColor) {
        this.mOkKeyTintColor = okKeyTintColor;
    }

    public KeyEntry getBoundKey() {
        return this.mBoundKey;
    }

    public void bindKey(KeyEntry bindKey) {
        this.mBoundKey = bindKey;
        this.mDrawPressedText = false;
        if (bindKey.keyType == KeyType.FUNC_OK) {
            Drawable drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.pwk_keyboard_key_general_bg);
            Drawable tintDrawable = DrawableTint.tint(drawable2, this.mOkKeyTintColor);
            this.setBackgroundDrawable(tintDrawable);
            this.setTextColor(ContextCompat.getColorStateList((Context)this.getContext(), (int)R.color.pwk_keyboard_key_ok_text));
        } else {
            this.setTextColor(ContextCompat.getColorStateList((Context)this.getContext(), (int)R.color.pwk_keyboard_key_text));
            this.setBackgroundResource(R.drawable.pwk_keyboard_key_general_bg);
        }
    }

    public void setShowBubble(boolean showBubble) {
        this.mShowBubble = showBubble;
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, type);
        if (this.mBubbleDrawable != null) {
            this.mBubbleDrawable.setText(String.valueOf(text));
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        KeyEntry keyEntry = this.mBoundKey;
        if (keyEntry == null) {
            return;
        }
        if (keyEntry.keyType == KeyType.FUNC_DELETE) {
            this.drawDeleteKey(canvas);
        } else if (keyEntry.keyType == KeyType.GENERAL && this.mDrawPressedText) {
            canvas.save();
            canvas.translate((float)((this.getWidth() - this.mBubbleDrawable.getIntrinsicWidth()) / 2), (float)(-this.mBubbleDrawable.getIntrinsicHeight()));
            this.mBubbleDrawable.draw(canvas);
            canvas.restore();
        }
    }

    private void drawDeleteKey(Canvas canvas) {
        if (this.mDeleteDrawable == null) {
            this.mDeleteDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.pwk_key_delete);
            this.mDeleteDrawable.setBounds(0, 0, this.mDeleteDrawable.getIntrinsicWidth(), this.mDeleteDrawable.getIntrinsicHeight());
        }
        canvas.save();
        canvas.translate((float)((this.getWidth() - this.mDeleteDrawable.getIntrinsicWidth()) / 2), (float)((this.getHeight() - this.mDeleteDrawable.getIntrinsicHeight()) / 2));
        this.mDeleteDrawable.draw(canvas);
        canvas.restore();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mShowBubble || !this.isEnabled()) {
            return super.onTouchEvent(event);
        }
        int action = event.getActionMasked();
        if (action == 0) {
            this.mDrawPressedText = true;
        } else if (action == 2) {
            float x = event.getX(event.getActionIndex());
            float y = event.getY(event.getActionIndex());
            if (this.mDrawPressedText && (x < 0.0f || x > (float)this.getWidth() || y < 0.0f || y > (float)this.getHeight())) {
                this.mDrawPressedText = false;
                this.invalidate();
            }
        } else if (action == 1 || action == 3) {
            this.mDrawPressedText = false;
            this.invalidate();
        }
        if (this.mDrawPressedText) {
            this.invalidate();
        }
        return super.onTouchEvent(event);
    }
}

