/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.keyboard;

import android.app.Activity;
import android.content.Context;
import com.parkingwang.keyboard.KeyboardInputController;
import com.parkingwang.keyboard.PopupHelper;
import com.parkingwang.keyboard.engine.KeyboardEngine;
import com.parkingwang.keyboard.view.InputView;
import com.parkingwang.keyboard.view.KeyboardView;

public class PopupKeyboard {
    private final KeyboardView mKeyboardView;
    private KeyboardInputController mController;

    public PopupKeyboard(Context context) {
        this.mKeyboardView = new KeyboardView(context);
    }

    public KeyboardView getKeyboardView() {
        return this.mKeyboardView;
    }

    public void attach(InputView inputView, final Activity activity) {
        if (this.mController == null) {
            this.mController = KeyboardInputController.with(this.mKeyboardView, inputView);
            this.mController.useDefaultMessageHandler();
            inputView.addOnFieldViewSelectedListener(new InputView.OnFieldViewSelectedListener(){

                @Override
                public void onSelectedAt(int index) {
                    PopupKeyboard.this.show(activity);
                }
            });
        }
    }

    public KeyboardInputController getController() {
        return this.checkAttachedController();
    }

    public KeyboardEngine getKeyboardEngine() {
        return this.mKeyboardView.getKeyboardEngine();
    }

    public void show(Activity activity) {
        this.checkAttachedController();
        PopupHelper.showToActivity(activity, this.mKeyboardView);
    }

    public void dismiss(Activity activity) {
        this.checkAttachedController();
        PopupHelper.dismissFromActivity(activity);
    }

    public boolean isShown() {
        return this.mKeyboardView.isShown();
    }

    private KeyboardInputController checkAttachedController() {
        if (this.mController == null) {
            throw new IllegalStateException("Try attach() first");
        }
        return this.mController;
    }
}

