/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.keyboard.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.widget.LinearLayout;
import com.parkingwang.keyboard.engine.KeyEntry;
import com.parkingwang.keyboard.engine.KeyType;
import com.parkingwang.keyboard.view.KeyView;
import com.parkingwang.vehiclekeyboard.R;

final class KeyRowLayout
extends LinearLayout {
    private static final int NARROW_SPACE_KEY_COUNT = 10;
    private static final float RATIO_FUN_CONFIRM = 0.625f;
    private int mGeneralKeySpace;
    private int mFunKeySpace;
    private int mMaxColumn;
    private int mFunKeyIndex;
    private int mWidthUnused;
    private int mFunKeyCount;

    public KeyRowLayout(Context context) {
        super(context);
        this.setOrientation(0);
        Drawable keyDivider = ContextCompat.getDrawable((Context)context, (int)R.drawable.pwk_space_horizontal);
        this.mFunKeySpace = keyDivider.getIntrinsicWidth();
        this.setShowDividers(2);
        this.setClipToPadding(false);
        this.setClipChildren(false);
    }

    public void setMaxColumn(int maxColumn) {
        this.mMaxColumn = maxColumn;
        Drawable keyDivider = this.mMaxColumn < 10 ? ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.pwk_space_horizontal) : ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.pwk_space_horizontal_narrow);
        this.mGeneralKeySpace = keyDivider.getIntrinsicWidth();
        this.setDividerDrawable(keyDivider);
    }

    public void setFunKeyCount(int funKeyCount) {
        this.mFunKeyCount = funKeyCount;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int childCount = this.getChildCount();
        int functionKeyWidth = (int)((float)((width - 9 * this.mGeneralKeySpace) * 3 / 10 + this.mGeneralKeySpace) * 0.625f);
        float generalKeyWidth = this.getGeneralKeyWidth(width, functionKeyWidth);
        int widthUsed = 0;
        this.mFunKeyIndex = 0;
        for (int i = 0; i < childCount; ++i) {
            View view = this.getChildAt(i);
            if (!(view instanceof KeyView)) continue;
            KeyView keyView = (KeyView)view;
            KeyEntry keyEntry = keyView.getBoundKey();
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)keyView.getLayoutParams();
            if (keyEntry.keyType == KeyType.GENERAL) {
                params.width = (int)generalKeyWidth;
            } else {
                params.width = functionKeyWidth;
                if (this.mFunKeyIndex == 0) {
                    this.mFunKeyIndex = i;
                }
            }
            widthUsed += params.width + this.mGeneralKeySpace;
        }
        this.mWidthUnused = width - (widthUsed -= this.mGeneralKeySpace);
        if (this.mFunKeyCount > 0) {
            this.setPadding(0, 0, 0, 0);
        } else {
            int padding = this.mWidthUnused / 2;
            this.setPadding(padding, this.getPaddingTop(), padding, this.getPaddingBottom());
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private float getGeneralKeyWidth(int width, int functionKeyWidth) {
        int generalKeyCount;
        float availableGeneralKeyWidth;
        float generalKeyWidth = (width - (this.mMaxColumn - 1) * this.mGeneralKeySpace) / this.mMaxColumn;
        int funKeyWidthUsed = 0;
        if (this.mFunKeyCount > 0) {
            funKeyWidthUsed = functionKeyWidth * this.mFunKeyCount + this.mFunKeySpace * (this.mFunKeyCount - 1) + this.mGeneralKeySpace;
        }
        if ((availableGeneralKeyWidth = (float)(width - funKeyWidthUsed - ((generalKeyCount = this.getChildCount() - this.mFunKeyCount) - 1) * this.mGeneralKeySpace)) < generalKeyWidth * (float)generalKeyCount) {
            generalKeyWidth = availableGeneralKeyWidth / (float)generalKeyCount;
        }
        return generalKeyWidth;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        for (int i = 0; i < this.mFunKeyCount; ++i) {
            ViewCompat.offsetLeftAndRight((View)this.getChildAt(this.mFunKeyIndex + i), (int)this.mWidthUnused);
        }
    }
}

