/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.keyboard.neighbor;

import android.text.TextUtils;
import com.parkingwang.keyboard.neighbor.Province;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class NeighborManager {
    private final Set<Province> mProvinces = new HashSet<Province>(32);

    public NeighborManager() {
        Province beijing = new Province("\u5317\u4eac\u5e02", "\u4eac");
        Province tianjin = new Province("\u5929\u6d25\u5e02", "\u6d25");
        Province shanxi = new Province("\u5c71\u897f\u7701", "\u664b");
        Province hebei = new Province("\u6cb3\u5317\u7701", "\u5180");
        Province neimenggu = new Province("\u5185\u8499\u53e4\u81ea\u6cbb\u533a", "\u8499");
        Province liaoning = new Province("\u8fbd\u5b81\u7701", "\u8fbd");
        Province jilin = new Province("\u5409\u6797\u7701", "\u5409");
        Province heilongjiang = new Province("\u9ed1\u9f99\u6c5f\u7701", "\u9ed1");
        Province shanghai = new Province("\u4e0a\u6d77\u5e02", "\u6caa");
        Province jiangsu = new Province("\u6c5f\u82cf\u7701", "\u82cf");
        Province zhejiang = new Province("\u6d59\u6c5f\u7701", "\u6d59");
        Province anhui = new Province("\u5b89\u5fbd\u7701", "\u7696");
        Province fujian = new Province("\u798f\u5efa\u7701", "\u95fd");
        Province jiangxi = new Province("\u6c5f\u897f\u7701", "\u8d63");
        Province shandong = new Province("\u5c71\u4e1c\u7701", "\u9c81");
        Province henan = new Province("\u6cb3\u5357\u7701", "\u8c6b");
        Province hubei = new Province("\u6e56\u5317\u7701", "\u9102");
        Province hunan = new Province("\u6e56\u5357\u7701", "\u6e58");
        Province guangdong = new Province("\u5e7f\u4e1c\u7701", "\u7ca4");
        Province guangxi = new Province("\u5e7f\u897f\u58ee\u65cf\u81ea\u6cbb\u533a", "\u6842");
        Province hainan = new Province("\u6d77\u5357\u7701", "\u743c");
        Province chongqing = new Province("\u91cd\u5e86\u5e02", "\u6e1d");
        Province sichuan = new Province("\u56db\u5ddd\u7701", "\u5ddd");
        Province guizhou = new Province("\u8d35\u5dde\u7701", "\u8d35");
        Province yunnan = new Province("\u4e91\u5357\u7701", "\u4e91");
        Province xizang = new Province("\u897f\u85cf\u81ea\u6cbb\u533a", "\u85cf");
        Province shannxi = new Province("\u9655\u897f\u7701", "\u9655");
        Province gansu = new Province("\u7518\u8083\u7701", "\u7518");
        Province qinghai = new Province("\u9752\u6d77\u7701", "\u9752");
        Province ningxia = new Province("\u5b81\u590f\u56de\u65cf\u81ea\u6cbb\u533a", "\u5b81");
        Province xinjiang = new Province("\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a", "\u65b0");
        Province taiwan = new Province("\u53f0\u6e7e\u7701", "\u53f0");
        xinjiang.link(xizang).link(qinghai).link(gansu).link(neimenggu);
        xizang.link(qinghai).link(sichuan).link(yunnan);
        qinghai.link(gansu).link(sichuan).link(shanxi);
        gansu.link(neimenggu).link(shannxi).link(sichuan).link(chongqing).link(ningxia);
        ningxia.link(shannxi).link(gansu);
        neimenggu.link(heilongjiang).link(jilin).link(liaoning).link(hebei).link(beijing).link(tianjin).link(shanxi).link(shannxi).link(ningxia);
        shannxi.link(shanxi).link(henan).link(hubei).link(chongqing).link(sichuan);
        sichuan.link(yunnan).link(guizhou).link(chongqing);
        yunnan.link(guizhou).link(guangxi);
        guizhou.link(hunan).link(guangxi).link(chongqing).link(hubei);
        chongqing.link(hubei).link(hunan);
        hubei.link(hunan).link(henan).link(anhui).link(jiangxi);
        hunan.link(jiangxi).link(guangxi).link(guangdong);
        guangxi.link(guangdong).link(hainan);
        guangdong.link(hainan).link(fujian).link(jiangxi);
        jiangxi.link(fujian).link(anhui).link(zhejiang);
        fujian.link(zhejiang);
        fujian.link(taiwan);
        zhejiang.link(shanghai).link(anhui).link(jiangsu);
        anhui.link(jiangsu).link(shanghai).link(shandong);
        jiangsu.link(shandong).link(shanghai);
        shandong.link(hebei).link(beijing).link(tianjin);
        shanxi.link(hebei).link(henan);
        hebei.link(beijing).link(tianjin).link(shandong).link(liaoning);
        beijing.link(tianjin).link(liaoning).link(shandong);
        liaoning.link(jilin);
        jilin.link(liaoning).link(heilongjiang);
        this.bind(beijing, tianjin, shanxi, hebei, neimenggu, liaoning, jilin, heilongjiang, shanghai, jiangsu, zhejiang, anhui, fujian, jiangxi, shandong, henan, hubei, hunan, guangdong, guangxi, hainan, chongqing, sichuan, guizhou, yunnan, xizang, shannxi, gansu, qinghai, ningxia, xinjiang);
    }

    public Province getLocation(String provinceName) {
        if (TextUtils.isEmpty((CharSequence)provinceName)) {
            return new Province("", "");
        }
        provinceName = provinceName.replace("\u7701", "");
        for (Province p : this.mProvinces) {
            if (!p.name.contains(provinceName)) continue;
            return p;
        }
        return new Province("", "");
    }

    private void bind(Province ... provinces) {
        this.mProvinces.addAll(Arrays.asList(provinces));
    }
}

