/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.keyboard.engine;

import com.parkingwang.keyboard.engine.AvailableKeyRegistry;
import com.parkingwang.keyboard.engine.BackKeyTransformer;
import com.parkingwang.keyboard.engine.Context;
import com.parkingwang.keyboard.engine.FuncKeyTransformer;
import com.parkingwang.keyboard.engine.KeyboardEntry;
import com.parkingwang.keyboard.engine.LayoutEntry;
import com.parkingwang.keyboard.engine.LayoutManager;
import com.parkingwang.keyboard.engine.Mixer;
import com.parkingwang.keyboard.engine.MoreKeyTransformer;
import com.parkingwang.keyboard.engine.NumberType;

public class KeyboardEngine {
    private final AvailableKeyRegistry mKeyRegistry = new AvailableKeyRegistry();
    private final LayoutManager mKeyboardLayout = new LayoutManager();
    private final Mixer mMixer = new Mixer();

    public KeyboardEngine() {
        this.mMixer.addMapper(new FuncKeyTransformer());
        this.mMixer.addMapper(new MoreKeyTransformer());
        this.mMixer.addMapper(new BackKeyTransformer());
    }

    public void setHideOKKey(boolean hide) {
        this.mMixer.setRemoveFuncOK(hide);
    }

    public KeyboardEntry update(String presetNumber, int selectCharIndex, boolean showMoreLayout, NumberType fixedNumberType) {
        NumberType detectNumberType = NumberType.AUTO_DETECT.equals((Object)fixedNumberType) ? NumberType.detect(presetNumber) : fixedNumberType;
        int maxLength = detectNumberType.maxLength();
        Context context = new Context(presetNumber, selectCharIndex, detectNumberType, maxLength, this.mKeyRegistry.available(detectNumberType, selectCharIndex), showMoreLayout);
        LayoutEntry layout2 = this.mKeyboardLayout.getLayout(context);
        LayoutEntry output = this.mMixer.mix(context, layout2);
        return new KeyboardEntry(selectCharIndex, presetNumber, maxLength, output, detectNumberType);
    }
}

