/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.keyboard;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.parkingwang.keyboard.view.KeyboardView;
import com.parkingwang.vehiclekeyboard.R;

public class PopupHelper {
    public static boolean showToActivity(Activity activity, KeyboardView keyboardView) {
        View decorView = activity.getWindow().getDecorView();
        FrameLayout keyboardWrapper = (FrameLayout)decorView.findViewById(R.id.keyboard_wrapper_id);
        if (keyboardWrapper == null) {
            ViewParent keyboardViewParent = keyboardView.getParent();
            if (keyboardViewParent != null && ((View)keyboardViewParent).getId() == R.id.keyboard_wrapper_id && keyboardViewParent instanceof FrameLayout) {
                keyboardWrapper = (FrameLayout)keyboardViewParent;
                PopupHelper.makeSureHasNoParent((View)keyboardWrapper);
            }
            if (keyboardWrapper == null) {
                keyboardWrapper = PopupHelper.wrapKeyboardView(activity, keyboardView);
            }
            if (decorView instanceof FrameLayout) {
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
                params.gravity = 80;
                params.bottomMargin = PopupHelper.getNavigationBarHeight((Context)activity);
                ((ViewGroup)decorView).addView((View)keyboardWrapper, (ViewGroup.LayoutParams)params);
            }
            return true;
        }
        keyboardWrapper.setVisibility(0);
        keyboardWrapper.bringToFront();
        return false;
    }

    @NonNull
    private static FrameLayout wrapKeyboardView(Activity activity, KeyboardView keyboardView) {
        FrameLayout keyboardWrapper = new FrameLayout((Context)activity);
        keyboardWrapper.setId(R.id.keyboard_wrapper_id);
        keyboardWrapper.setClipChildren(false);
        FrameLayout.LayoutParams keyboardParams = new FrameLayout.LayoutParams(-1, -2, 80);
        keyboardWrapper.addView((View)keyboardView, (ViewGroup.LayoutParams)keyboardParams);
        return keyboardWrapper;
    }

    private static int getNavigationBarHeight(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        int appUsableHeight = size.y;
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealSize(size);
        } else {
            try {
                size.y = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception e) {
                return 0;
            }
        }
        return size.y - appUsableHeight;
    }

    private static void makeSureHasNoParent(View view) {
        if (view.getParent() != null) {
            ((ViewGroup)view.getParent()).removeView(view);
        }
    }

    public static boolean dismissFromActivity(Activity activity) {
        View view = activity.getWindow().getDecorView().findViewById(R.id.keyboard_wrapper_id);
        if (view == null) {
            return false;
        }
        ((ViewGroup)view.getParent()).removeView(view);
        return true;
    }
}

