/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.vehiclekeyboard.core;

import com.parkingwang.vehiclekeyboard.core.KeyEntry;
import com.parkingwang.vehiclekeyboard.core.NumberType;
import com.parkingwang.vehiclekeyboard.core.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PrepareKeyRegistry {
    private final Map<String, List<KeyEntry>> mCache = new HashMap<String, List<KeyEntry>>();

    PrepareKeyRegistry() {
        List<KeyEntry> lettersNumeric = Utils.mkEntitiesOf("QWERTYUPASDFGHJKLZXCVBNM0123456789");
        List<KeyEntry> civilProvince = Utils.mkEntitiesOf("\u4eac\u6d25\u664b\u5180\u8499\u8fbd\u5409\u9ed1\u6caa\u82cf\u6d59\u7696\u95fd\u8d63\u9c81\u8c6b\u9102\u6e58\u7ca4\u6842\u743c\u6e1d\u5ddd\u8d35\u4e91\u85cf\u9655\u7518\u9752\u5b81\u65b0");
        List<KeyEntry> lettersHasO = Utils.mkEntitiesOf("QWERTYUOPASDFGHJKLZXCVBNM");
        List civilPost = Utils.append(lettersNumeric, Utils.mkEntitiesOf("\u8b66\u5b66\u6302\u8bd5\u8d85"));
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.CIVIL, 0), civilProvince);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.CIVIL, 1), lettersHasO);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.CIVIL, 2), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.CIVIL, 3), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.CIVIL, 4), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.CIVIL, 5), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.CIVIL, 6), civilPost);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.CIVIL, 200), civilPost);
        List<KeyEntry> numericDF = Utils.mkEntitiesOf("0123456789DF");
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.NEW_ENERGY, 0), civilProvince);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.NEW_ENERGY, 1), lettersHasO);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.NEW_ENERGY, 2), numericDF);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.NEW_ENERGY, 3), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.NEW_ENERGY, 4), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.NEW_ENERGY, 5), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.NEW_ENERGY, 6), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.NEW_ENERGY, 7), numericDF);
        List<KeyEntry> hkMacao = Utils.mkEntitiesOf("\u6e2f\u6fb3");
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.HK_MACAO, 0), civilProvince);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.HK_MACAO, 1), Utils.mkEntitiesOf("Z"));
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.HK_MACAO, 2), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.HK_MACAO, 3), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.HK_MACAO, 4), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.HK_MACAO, 5), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.HK_MACAO, 6), hkMacao);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.HK_MACAO, 200), hkMacao);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.WJ2012, 0), Utils.mkEntitiesOf("W"));
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.WJ2012, 1), Utils.mkEntitiesOf("J"));
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.WJ2012, 2), civilProvince);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.WJ2012, 3), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.WJ2012, 4), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.WJ2012, 5), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.WJ2012, 6), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.WJ2012, 7), Utils.mkEntitiesOf("0123456789XBTSHJD"));
        List<KeyEntry> numeric = Utils.mkEntitiesOf("0123456789");
        List<KeyEntry> numeric123 = Utils.mkEntitiesOf("123");
        List<KeyEntry> shi = Utils.mkEntitiesOf("\u4f7f");
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.SHI2017, 100), shi);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.SHI2017, 0), numeric123);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.SHI2017, 1), numeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.SHI2017, 2), numeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.SHI2017, 3), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.SHI2017, 4), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.SHI2017, 5), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.SHI2017, 6), shi);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.SHI2017, 200), shi);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.SHI2012, 100), shi);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.SHI2012, 0), shi);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.SHI2012, 1), numeric123);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.SHI2012, 2), numeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.SHI2012, 3), numeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.SHI2012, 4), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.SHI2012, 5), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.SHI2012, 6), lettersNumeric);
        List<KeyEntry> pla2012 = Utils.mkEntitiesOf("QERTYUPASDFGHJKLZXCVBNM");
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.PLA2012, 100), pla2012);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.PLA2012, 1), lettersHasO);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.PLA2012, 2), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.PLA2012, 3), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.PLA2012, 4), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.PLA2012, 5), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.PLA2012, 6), lettersNumeric);
        List<KeyEntry> ling = Utils.mkEntitiesOf("\u9886");
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.LING2018, 0), civilProvince);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.LING2018, 1), lettersHasO);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.LING2018, 2), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.LING2018, 3), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.LING2018, 4), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.LING2018, 5), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.LING2018, 200), ling);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.LING2018, 0), civilProvince);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.LING2018, 1), numeric123);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.LING2018, 2), numeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.LING2018, 3), numeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.LING2018, 4), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.LING2018, 5), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.LING2018, 6), ling);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.AVIATION, 0), Utils.mkEntitiesOf("\u6c11"));
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.AVIATION, 1), Utils.mkEntitiesOf("\u822a"));
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.AVIATION, 2), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.AVIATION, 3), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.AVIATION, 4), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.AVIATION, 5), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.AVIATION, 6), lettersNumeric);
        List auto = Utils.append(civilProvince, lettersNumeric, Utils.mkEntitiesOf("\u6c11\u4f7f"));
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.AUTO_DETECT, 100), auto);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.AUTO_DETECT, 0), auto);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.AUTO_DETECT, 1), Utils.append(lettersHasO, numeric123, Utils.mkEntitiesOf("\u822aJ")));
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.AUTO_DETECT, 2), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.AUTO_DETECT, 3), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.AUTO_DETECT, 4), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.AUTO_DETECT, 5), lettersNumeric);
        this.mCache.put(PrepareKeyRegistry.mkKey(NumberType.AUTO_DETECT, 6), civilPost);
    }

    public List<KeyEntry> available(NumberType type, int selectedIndex) {
        List<KeyEntry> found = this.mCache.get(PrepareKeyRegistry.mkKey(type, selectedIndex));
        if (null != found) {
            return found;
        }
        return Collections.emptyList();
    }

    private static String mkKey(NumberType type, int index) {
        return "@" + type.name() + "." + index;
    }
}

