/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.vehiclekeyboard.core;

import com.parkingwang.vehiclekeyboard.core.Env;
import com.parkingwang.vehiclekeyboard.core.KeyEntry;
import com.parkingwang.vehiclekeyboard.core.NumberType;
import com.parkingwang.vehiclekeyboard.core.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class LayoutRegistry {
    private final Map<String, List<List<KeyEntry>>> mCache = new HashMap<String, List<List<KeyEntry>>>();

    LayoutRegistry() {
        this.mCache.put(LayoutRegistry.keyAt(100), LayoutRegistry.createRows("123456789", "QWEYCVBN0", "ASDFGHJKL", "ZX\u6c11\u4f7f<-+"));
        this.mCache.put(LayoutRegistry.keyAt(200), LayoutRegistry.createRows("\u5b66\u8b66\u6e2f\u6fb3\u4f7f\u9886\u822a\u6302\u8bd5\u8d85", "1234567890", "ABCDEFGHJK", "WXYZ<-+"));
        this.mCache.put(LayoutRegistry.keyAt(0), LayoutRegistry.createRows("\u4eac\u6d25\u664b\u5180\u8499\u8fbd\u5409\u9ed1\u6caa", "\u82cf\u6d59\u7696\u95fd\u8d63\u9c81\u8c6b\u9102\u6e58", "\u7ca4\u6842\u743c\u6e1d\u5ddd\u8d35\u4e91\u85cf\u9655", "\u7518\u9752\u5b81\u65b0>-+"));
        this.mCache.put(LayoutRegistry.keyAt(1), LayoutRegistry.createRows("1234567890", "QWERTYUIOP", "ASDFGHJKLM", "ZXCVBN-+"));
        List<List<KeyEntry>> civil = LayoutRegistry.createRows("1234567890", "QWERTYUPMN", "ASDFGHJKLB", "ZXCV>-+");
        this.mCache.put(LayoutRegistry.keyAt(2), civil);
        this.mCache.put(LayoutRegistry.keyAt(3), civil);
        this.mCache.put(LayoutRegistry.keyAt(4), civil);
        this.mCache.put(LayoutRegistry.keyAt(5), civil);
        this.mCache.put(LayoutRegistry.keyAt(6), civil);
        this.mCache.put(LayoutRegistry.keyAt(7), civil);
    }

    public List<List<KeyEntry>> layout(Env env, int selectIndex) {
        switch (env.selectIndex) {
            default: {
                return this.cached(selectIndex);
            }
            case 1: {
                if (NumberType.AVIATION.equals((Object)env.numberType)) {
                    return this.cached(200);
                }
                return this.cached(selectIndex);
            }
            case 2: {
                if (NumberType.WJ2012.equals((Object)env.numberType)) {
                    return this.cached(0);
                }
                return this.cached(selectIndex);
            }
            case 6: 
        }
        switch (env.numberType) {
            case HK_MACAO: 
            case SHI2017: 
            case LING2012: 
            case LING2018: {
                return this.cached(200);
            }
        }
        return this.cached(selectIndex);
    }

    private List<List<KeyEntry>> cached(int selectIndex) {
        List<List<KeyEntry>> found = this.mCache.get(LayoutRegistry.keyAt(selectIndex));
        if (null != found) {
            return found;
        }
        return Collections.emptyList();
    }

    private static List<List<KeyEntry>> createRows(String ... rows) {
        ArrayList<List<KeyEntry>> layout2 = new ArrayList<List<KeyEntry>>(rows.length);
        for (String keys : rows) {
            layout2.add(Utils.mkEntitiesOf(keys));
        }
        return layout2;
    }

    private static String keyAt(int selectIndex) {
        return "@Layout." + selectIndex;
    }
}

