/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.vehiclekeyboard.core;

public enum NumberType {
    AUTO_DETECT,
    CIVIL,
    NEW_ENERGY,
    HK_MACAO,
    WJ2012,
    PLA2012,
    SHI2012,
    SHI2017,
    LING2012,
    LING2018,
    AVIATION;


    public static NumberType detect(String number) {
        if (null == number) {
            return AUTO_DETECT;
        }
        int size = number.length();
        if (0 == size) {
            return AUTO_DETECT;
        }
        char firstChar = (number = number.toUpperCase()).charAt(0);
        if (NumberType.contains("QERTYUPASDFGHJKLZXCVBNM", firstChar)) {
            return PLA2012;
        }
        if ('\u4f7f' == firstChar) {
            return SHI2012;
        }
        if (NumberType.contains("123", firstChar)) {
            return SHI2017;
        }
        if ('\u6c11' == firstChar) {
            return AVIATION;
        }
        if ('W' == firstChar) {
            return WJ2012;
        }
        char lastChar = number.charAt(Math.max(0, size - 1));
        if ('\u9886' == lastChar) {
            if (size > 2) {
                char secondChar = number.charAt(1);
                if (NumberType.contains("QWERTYUOPASDFGHJKLZXCVBNM", secondChar)) {
                    return LING2012;
                }
                return LING2018;
            }
            return LING2018;
        }
        if (number.startsWith("\u7ca4Z") || number.contains("\u6e2f\u6fb3")) {
            return HK_MACAO;
        }
        if (size == 8) {
            return NEW_ENERGY;
        }
        return CIVIL;
    }

    public int maxLength() {
        switch (this) {
            case WJ2012: 
            case NEW_ENERGY: {
                return 8;
            }
        }
        return 7;
    }

    private static boolean contains(String s, char c) {
        return s.indexOf(c) >= 0;
    }
}

