/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.vehiclekeyboard.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import com.parkingwang.vehiclekeyboard.R;
import com.parkingwang.vehiclekeyboard.view.FieldViewGroup;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class InputView
extends LinearLayout {
    private static final String TAG = InputView.class.getName();
    private static final String KEY_INIT_NUMBER = "pwk.keyboard.key:init.number";
    private final HashMap<String, Object> mKeyMap = new HashMap();
    private final Set<OnFieldViewSelectedListener> mOnFieldViewSelectedListeners = new HashSet<OnFieldViewSelectedListener>(4);
    private final FieldViewGroup mFieldViewGroup;
    private final View.OnClickListener mOnFieldViewClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            Log.d((String)TAG, (String)"Click Handler: ----");
            ClickMetas clickMetas = InputView.this.getClickedMeta((Button)v);
            if (clickMetas.clickIndex <= clickMetas.numberLength) {
                if (clickMetas.clickIndex != clickMetas.selectedIndex) {
                    if (clickMetas.selectedIndex >= 0) {
                        InputView.this.clearSelectedState(InputView.this.mFieldViewGroup.getFieldAt(clickMetas.selectedIndex));
                    }
                    Log.d((String)TAG, (String)("\u5f53\u524d\u70b9\u51fb\u5e8f\u53f7: " + clickMetas.clickIndex));
                    InputView.this.setFieldViewSelected(InputView.this.mFieldViewGroup.getFieldAt(clickMetas.clickIndex));
                }
                for (OnFieldViewSelectedListener listener : InputView.this.mOnFieldViewSelectedListeners) {
                    listener.onSelectedAt(clickMetas.clickIndex);
                }
            }
        }
    };

    public InputView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        InputView.inflate((Context)context, (int)R.layout.pwk_input_view, (ViewGroup)this);
        this.mFieldViewGroup = new FieldViewGroup(){

            @Override
            protected Button findViewById(int id2) {
                return (Button)InputView.this.findViewById(id2);
            }
        };
        this.onInited(context, attrs);
    }

    public InputView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        InputView.inflate((Context)context, (int)R.layout.pwk_input_view, (ViewGroup)this);
        this.mFieldViewGroup = new FieldViewGroup(){

            @Override
            protected Button findViewById(int id2) {
                return (Button)InputView.this.findViewById(id2);
            }
        };
        this.onInited(context, attrs);
    }

    private void onInited(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.InputView);
        float textSize = ta.getDimension(R.styleable.InputView_pwkInputTextSize, 0.0f);
        ta.recycle();
        this.mFieldViewGroup.setupAllFieldsTextSize(textSize);
        this.mFieldViewGroup.setupAllFieldsOnClickListener(this.mOnFieldViewClickListener);
        this.mFieldViewGroup.changeTo7Fields();
    }

    public void updateSelectedCharAndSelectNext(String text) {
        Button selected = this.mFieldViewGroup.getFirstSelectedFieldOrNull();
        if (selected != null) {
            selected.setText((CharSequence)text);
            this.performNextFieldViewBy(selected);
        }
    }

    public void removeLastCharOfNumber() {
        Button last = this.mFieldViewGroup.getLastFilledFieldOrNull();
        if (last != null) {
            last.setText(null);
            this.performFieldViewSetToSelected(last);
        }
    }

    public boolean isCompleted() {
        return this.mFieldViewGroup.isAllFieldsFilled();
    }

    public boolean isNumberChanged() {
        String current = this.getNumber();
        return !current.equals(String.valueOf(this.mKeyMap.get(KEY_INIT_NUMBER)));
    }

    public void updateNumber(String number) {
        this.mKeyMap.put(KEY_INIT_NUMBER, number);
        this.mFieldViewGroup.setTextToFields(number);
    }

    public String getNumber() {
        return this.mFieldViewGroup.getText();
    }

    public void performFirstFieldView() {
        this.performFieldViewSetToSelected(this.mFieldViewGroup.getFieldAt(0));
    }

    public void performLastPendingFieldView() {
        Button field = this.mFieldViewGroup.getLastFilledFieldOrNull();
        if (field != null) {
            this.performNextFieldViewBy(field);
        } else {
            this.performFieldViewSetToSelected(this.mFieldViewGroup.getFieldAt(0));
        }
    }

    public void performNextFieldView() {
        ClickMetas clickMetas = this.getClickedMeta(null);
        if (clickMetas.selectedIndex >= 0) {
            Button current = this.mFieldViewGroup.getFieldAt(clickMetas.selectedIndex);
            if (!TextUtils.isEmpty((CharSequence)current.getText())) {
                this.performNextFieldViewBy(current);
            } else {
                this.performFieldViewSetToSelected(current);
            }
        }
    }

    public void rePerformCurrentFieldView() {
        ClickMetas clickMetas = this.getClickedMeta(null);
        if (clickMetas.selectedIndex >= 0) {
            this.performFieldViewSetToSelected(this.mFieldViewGroup.getFieldAt(clickMetas.selectedIndex));
        }
    }

    public void set8thVisibility(boolean setToShow8thField) {
        Button field;
        boolean changed = setToShow8thField ? this.mFieldViewGroup.changeTo8Fields() : this.mFieldViewGroup.changeTo7Fields();
        if (changed && (field = this.mFieldViewGroup.getFirstEmptyField()) != null) {
            Log.d((String)TAG, (String)("[@@ FieldChanged @@] FirstEmpty.tag: " + field.getTag()));
            this.setFieldViewSelected(field);
        }
    }

    public boolean isLastFieldViewSelected() {
        return this.mFieldViewGroup.getLastField().isSelected();
    }

    public InputView addOnFieldViewSelectedListener(OnFieldViewSelectedListener listener) {
        this.mOnFieldViewSelectedListeners.add(listener);
        return this;
    }

    private void performFieldViewSetToSelected(Button target) {
        Log.d((String)TAG, (String)("[== FastPerform ==] Btn.text: " + target.getText()));
        this.mOnFieldViewClickListener.onClick((View)target);
        this.setFieldViewSelected(target);
    }

    private void performNextFieldViewBy(Button current) {
        int nextIndex = this.mFieldViewGroup.getNextIndexOfField(current);
        Log.d((String)TAG, (String)("[>> NextPerform >>] Next.Btn.idx: " + nextIndex));
        this.performFieldViewSetToSelected(this.mFieldViewGroup.getFieldAt(nextIndex));
    }

    private void clearSelectedState(Button target) {
        target.setSelected(false);
    }

    private void setFieldViewSelected(Button target) {
        for (Button btn : this.mFieldViewGroup.getAvailableFields()) {
            btn.setSelected(btn == target);
        }
    }

    private ClickMetas getClickedMeta(Button clicked) {
        short selected = -1;
        short current = 0;
        short length = 0;
        Button[] fields = this.mFieldViewGroup.getAvailableFields();
        for (int i = 0; i < fields.length; ++i) {
            Button item = fields[i];
            if (item == clicked) {
                current = (short)i;
            }
            if (item.isSelected()) {
                selected = (short)i;
            }
            if (InputView.isButtonEmpty(item)) continue;
            length = (short)(length + 1);
        }
        return new ClickMetas(selected, current, length);
    }

    private static boolean isButtonEmpty(Button button) {
        return button.getText().length() == 0;
    }

    public static interface OnFieldViewSelectedListener {
        public void onSelectedAt(int var1);
    }

    private static class ClickMetas {
        final short selectedIndex;
        final short clickIndex;
        final short numberLength;

        private ClickMetas(short selectedIndex, short clickIndex, short numberLength) {
            this.selectedIndex = selectedIndex;
            this.clickIndex = clickIndex;
            this.numberLength = numberLength;
        }
    }
}

