/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.vehiclekeyboard.core;

import com.parkingwang.vehiclekeyboard.core.Env;
import com.parkingwang.vehiclekeyboard.core.KeyEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Mixer {
    private final List<Mapper> mMappers = new ArrayList<Mapper>();

    public List<List<KeyEntry>> mix(Env env, List<List<KeyEntry>> layout2) {
        ArrayList<List<KeyEntry>> output = new ArrayList<List<KeyEntry>>();
        for (List<KeyEntry> layoutRow : layout2) {
            ArrayList<KeyEntry> row = new ArrayList<KeyEntry>(layoutRow.size());
            Iterator<KeyEntry> iterator = layoutRow.iterator();
            while (iterator.hasNext()) {
                KeyEntry item;
                KeyEntry key = item = iterator.next();
                for (Mapper mapper : this.mMappers) {
                    KeyEntry ret = mapper.map(env, key);
                    if (null == ret) continue;
                    key = ret;
                }
                row.add(key);
            }
            output.add(row);
        }
        return output;
    }

    public void addMapper(Mapper mapper) {
        this.mMappers.add(mapper);
    }

    public static interface Mapper {
        public KeyEntry map(Env var1, KeyEntry var2);
    }
}

