/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.vehiclekeyboard.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.widget.LinearLayout;
import com.parkingwang.vehiclekeyboard.R;
import com.parkingwang.vehiclekeyboard.core.KeyEntry;
import com.parkingwang.vehiclekeyboard.core.KeyType;
import com.parkingwang.vehiclekeyboard.view.KeyView;

class KeyRowLayout
extends LinearLayout {
    private static final int NARROW_SPACE_KEY_COUNT = 10;
    private static final float RATIO_FUN_DEL = 0.375f;
    private static final float RATIO_FUN_CONFIRM = 0.625f;
    private int mGeneralKeySpace;
    private int mFunKeySpace;
    private int mMaxColumn;
    private int mFunKeyIndex;
    private int mWidthUnused;
    private int mFunKeyCount;

    public KeyRowLayout(Context context) {
        super(context);
        this.setOrientation(0);
        Drawable keyDivider = ContextCompat.getDrawable((Context)context, (int)R.drawable.pwk_space_horizontal);
        this.mFunKeySpace = keyDivider.getIntrinsicWidth();
        this.setShowDividers(2);
        this.setClipToPadding(false);
        this.setClipChildren(false);
    }

    public void setMaxColumn(int maxColumn) {
        this.mMaxColumn = maxColumn;
        Drawable keyDivider = this.mMaxColumn < 10 ? ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.pwk_space_horizontal) : ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.pwk_space_horizontal_narrow);
        this.mGeneralKeySpace = keyDivider.getIntrinsicWidth();
        this.setDividerDrawable(keyDivider);
    }

    public void setFunKeyCount(int funKeyCount) {
        this.mFunKeyCount = funKeyCount;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int childCount = this.getChildCount();
        int delAndConfirmWidth = (width - 9 * this.mFunKeySpace) * 3 / 10 + this.mFunKeySpace;
        int deleteKeyWidth = (int)((float)delAndConfirmWidth * 0.375f);
        int confirmKeyWidth = (int)((float)delAndConfirmWidth * 0.625f);
        float generalKeyWidth = this.getGeneralKeyWidth(width, delAndConfirmWidth, confirmKeyWidth);
        int widthUsed = 0;
        this.mFunKeyIndex = 0;
        for (int i = 0; i < childCount; ++i) {
            View view = this.getChildAt(i);
            if (!(view instanceof KeyView)) continue;
            KeyView keyView = (KeyView)view;
            KeyEntry keyEntry = keyView.getBoundKey();
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)keyView.getLayoutParams();
            if (keyEntry.keyType == KeyType.GENERAL) {
                params.width = (int)generalKeyWidth;
            } else {
                if (keyEntry.keyType == KeyType.FUNC_DELETE) {
                    if (this.mFunKeyCount == 2) {
                        params.width = deleteKeyWidth;
                        widthUsed += this.mFunKeySpace - this.mGeneralKeySpace;
                    } else {
                        params.width = confirmKeyWidth;
                    }
                } else {
                    params.width = confirmKeyWidth;
                }
                if (this.mFunKeyIndex == 0) {
                    this.mFunKeyIndex = i;
                }
            }
            widthUsed += params.width + this.mGeneralKeySpace;
        }
        this.mWidthUnused = width - (widthUsed -= this.mGeneralKeySpace);
        if (this.mFunKeyCount > 0) {
            this.setPadding(0, 0, 0, 0);
        } else {
            int padding = this.mWidthUnused / 2;
            this.setPadding(padding, this.getPaddingTop(), padding, this.getPaddingBottom());
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private float getGeneralKeyWidth(int width, int delAndConfirmWidth, int confirmKeyWidth) {
        float generalKeyWidth = (width - (this.mMaxColumn - 1) * this.mGeneralKeySpace) / this.mMaxColumn;
        int funKeyWidthUsed = 0;
        if (this.mFunKeyCount == 1) {
            funKeyWidthUsed = confirmKeyWidth + this.mGeneralKeySpace;
        } else if (this.mFunKeyCount == 2) {
            funKeyWidthUsed = delAndConfirmWidth + this.mGeneralKeySpace;
        }
        int generalKeyCount = this.getChildCount() - this.mFunKeyCount;
        float availableGeneralKeyWidth = width - funKeyWidthUsed - (generalKeyCount - 1) * this.mGeneralKeySpace;
        if (availableGeneralKeyWidth < generalKeyWidth * (float)generalKeyCount) {
            generalKeyWidth = availableGeneralKeyWidth / (float)generalKeyCount;
        }
        return generalKeyWidth;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        int offset = this.mFunKeySpace - this.mGeneralKeySpace;
        for (int i = 0; i < this.mFunKeyCount; ++i) {
            ViewCompat.offsetLeftAndRight((View)this.getChildAt(this.mFunKeyIndex + i), (int)(this.mWidthUnused + i * offset));
        }
    }
}

