/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.vehiclekeyboard.core;

import com.parkingwang.vehiclekeyboard.core.KeyEntry;
import com.parkingwang.vehiclekeyboard.core.KeyType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class Utils {
    private Utils() {
    }

    static <T> List<T> append(List<T> ... items) {
        ArrayList<T> output = new ArrayList<T>();
        for (List<T> s : items) {
            output.addAll(s);
        }
        return output;
    }

    static List<KeyEntry> mkEntitiesOf(String keysStr) {
        ArrayList<KeyEntry> keys = new ArrayList<KeyEntry>();
        for (int i = 0; i < keysStr.length(); ++i) {
            String keyChar = String.valueOf(keysStr.charAt(i));
            keys.add(Utils.mkEntry(keyChar));
        }
        return keys;
    }

    private static KeyEntry mkEntry(String text) {
        KeyType keyType;
        switch (text) {
            case "-": {
                keyType = KeyType.FUNC_DELETE;
                break;
            }
            case "+": {
                keyType = KeyType.FUNC_OK;
                break;
            }
            case ">": {
                keyType = KeyType.FUNC_MORE;
                break;
            }
            case "<": {
                keyType = KeyType.FUNC_BACK;
                break;
            }
            default: {
                keyType = KeyType.GENERAL;
            }
        }
        return new KeyEntry(text, keyType, false, !keyType.equals((Object)KeyType.GENERAL));
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static int hash(Object ... values) {
        return Arrays.hashCode(values);
    }
}

