/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.vehiclekeyboard;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;
import com.parkingwang.vehiclekeyboard.MessageHandler;
import com.parkingwang.vehiclekeyboard.OnInputChangedListener;
import com.parkingwang.vehiclekeyboard.R;
import com.parkingwang.vehiclekeyboard.core.KeyboardEntry;
import com.parkingwang.vehiclekeyboard.core.NumberType;
import com.parkingwang.vehiclekeyboard.support.Objects;
import com.parkingwang.vehiclekeyboard.support.Texts;
import com.parkingwang.vehiclekeyboard.view.InputView;
import com.parkingwang.vehiclekeyboard.view.KeyboardView;
import com.parkingwang.vehiclekeyboard.view.OnKeyboardChangedListener;
import java.util.LinkedHashSet;
import java.util.Set;

public class KeyboardInputController {
    private static final String TAG = "KeyboardInputController";
    private final KeyboardView mKeyboardView;
    private final InputView mInputView;
    private final Set<OnInputChangedListener> mOnInputChangedListeners = new LinkedHashSet<OnInputChangedListener>(4);
    private boolean mLockedOnNewEnergyType = false;
    private boolean mDebugEnabled = true;
    private MessageHandler mMessageHandler;

    public static KeyboardInputController with(KeyboardView keyboardView, InputView inputView) {
        return new KeyboardInputController(keyboardView, inputView);
    }

    public KeyboardInputController(KeyboardView keyboardView, InputView inputView) {
        this.mKeyboardView = keyboardView;
        this.mInputView = inputView;
        this.mInputView.addOnFieldViewSelectedListener(new InputView.OnFieldViewSelectedListener(){

            @Override
            public void onSelectedAt(int index) {
                String number = KeyboardInputController.this.mInputView.getNumber();
                if (KeyboardInputController.this.mDebugEnabled) {
                    Log.w((String)KeyboardInputController.TAG, (String)("\u70b9\u51fb\u8f93\u5165\u6846\u66f4\u65b0\u952e\u76d8, \u53f7\u7801\uff1a" + number + "\uff0c\u5e8f\u53f7\uff1a" + index));
                }
                if (KeyboardInputController.this.mLockedOnNewEnergyType) {
                    KeyboardInputController.this.mKeyboardView.update(number, index, NumberType.NEW_ENERGY);
                } else {
                    KeyboardInputController.this.mKeyboardView.update(number, index, NumberType.AUTO_DETECT);
                }
            }
        });
        this.mKeyboardView.addKeyboardChangedListener(this.syncKeyboardInputState());
        this.mKeyboardView.addKeyboardChangedListener(this.triggerInputChangedCallback());
    }

    public KeyboardInputController bindLockTypeProxy(final LockNewEnergyProxy proxy) {
        proxy.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                KeyboardInputController.this.tryLockNewEnergyType(!KeyboardInputController.this.mLockedOnNewEnergyType);
            }
        });
        this.mKeyboardView.addKeyboardChangedListener(new OnKeyboardChangedListener.Simple(){

            @Override
            public void onKeyboardChanged(KeyboardEntry keyboard) {
                if (NumberType.NEW_ENERGY.equals((Object)keyboard.currentNumberType)) {
                    KeyboardInputController.this.tryLockNewEnergyType(true);
                }
                proxy.onNumberTypeChanged(NumberType.NEW_ENERGY.equals((Object)keyboard.currentNumberType));
            }
        });
        return this;
    }

    public KeyboardInputController useDefaultMessageHandler() {
        return this.setMessageHandler(new MessageHandler(){

            @Override
            public void onMessageError(int message) {
                Toast.makeText((Context)KeyboardInputController.this.mKeyboardView.getContext(), (int)message, (int)0).show();
            }

            @Override
            public void onMessageTip(int message) {
                Toast.makeText((Context)KeyboardInputController.this.mKeyboardView.getContext(), (int)message, (int)0).show();
            }
        });
    }

    public void updateNumber(String number) {
        this.updateNumberLockType(number, false);
    }

    public void updateNumberLockType(String number, boolean lockedOnNewEnergyType) {
        String newNumber = number == null ? "" : number;
        this.mLockedOnNewEnergyType = lockedOnNewEnergyType;
        this.mInputView.updateNumber(newNumber);
        this.mInputView.performLastFieldView();
    }

    public KeyboardInputController setMessageHandler(MessageHandler handler) {
        this.mMessageHandler = Objects.notNull(handler);
        return this;
    }

    public KeyboardInputController addOnInputChangedListener(OnInputChangedListener listener) {
        this.mOnInputChangedListeners.add(Objects.notNull(listener));
        return this;
    }

    public KeyboardInputController removeOnInputChangedListener(OnInputChangedListener listener) {
        this.mOnInputChangedListeners.remove(Objects.notNull(listener));
        return this;
    }

    public KeyboardInputController setDebugEnabled(boolean enabled) {
        this.mDebugEnabled = enabled;
        return this;
    }

    private void updateInputViewItemsByNumberType(NumberType type) {
        if (NumberType.NEW_ENERGY.equals((Object)type) || NumberType.WJ2012.equals((Object)type) || this.mLockedOnNewEnergyType) {
            this.mInputView.set8thFieldViewVisibility(true, false);
        } else {
            this.mInputView.set8thFieldViewVisibility(false, !this.mInputView.isCompleted());
        }
    }

    private void tryLockNewEnergyType(boolean toLock) {
        if (toLock == this.mLockedOnNewEnergyType) {
            return;
        }
        boolean completed = this.mInputView.isCompleted();
        if (toLock) {
            this.triggerLockEnergyType(completed);
        } else {
            this.triggerUnlockEnergy(completed);
        }
    }

    private void triggerUnlockEnergy(boolean completed) {
        this.mLockedOnNewEnergyType = false;
        this.mMessageHandler.onMessageTip(R.string.pwk_now_is_normal);
        boolean lastItemSelected = this.mInputView.isLastFieldViewSelected();
        this.updateInputViewItemsByNumberType(NumberType.AUTO_DETECT);
        if (completed || lastItemSelected) {
            this.mInputView.performLastFieldView();
        } else {
            this.mInputView.performCurrentFieldView();
        }
    }

    private void triggerLockEnergyType(boolean completed) {
        if (Texts.isNewEnergyType(this.mInputView.getNumber())) {
            this.mLockedOnNewEnergyType = true;
            this.mMessageHandler.onMessageTip(R.string.pwk_now_is_energy);
            this.updateInputViewItemsByNumberType(NumberType.NEW_ENERGY);
            if (completed) {
                this.mInputView.performNextFieldView();
            } else {
                this.mInputView.performCurrentFieldView();
            }
        } else {
            this.mMessageHandler.onMessageError(R.string.pwk_change_to_energy_disallow);
        }
    }

    private OnKeyboardChangedListener triggerInputChangedCallback() {
        return new OnKeyboardChangedListener.Simple(){

            @Override
            public void onTextKey(String text) {
                this.notifyChanged();
            }

            @Override
            public void onDeleteKey() {
                this.notifyChanged();
            }

            @Override
            public void onConfirmKey() {
                String number = KeyboardInputController.this.mInputView.getNumber();
                for (OnInputChangedListener listener : KeyboardInputController.this.mOnInputChangedListeners) {
                    listener.onCompleted(number, false);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void notifyChanged() {
                boolean completed = KeyboardInputController.this.mInputView.isCompleted();
                String number = KeyboardInputController.this.mInputView.getNumber();
                try {
                    for (OnInputChangedListener listener : KeyboardInputController.this.mOnInputChangedListeners) {
                        listener.onChanged(number, completed);
                    }
                }
                finally {
                    if (completed) {
                        for (OnInputChangedListener listener : KeyboardInputController.this.mOnInputChangedListeners) {
                            listener.onCompleted(number, true);
                        }
                    }
                }
            }
        };
    }

    private OnKeyboardChangedListener syncKeyboardInputState() {
        return new OnKeyboardChangedListener.Simple(){

            @Override
            public void onTextKey(String text) {
                KeyboardInputController.this.mInputView.updateSelectedCharAndSelectNext(text);
            }

            @Override
            public void onDeleteKey() {
                KeyboardInputController.this.mInputView.removeLastCharOfNumber();
            }

            @Override
            public void onKeyboardChanged(KeyboardEntry keyboard) {
                if (KeyboardInputController.this.mDebugEnabled) {
                    Log.w((String)KeyboardInputController.TAG, (String)("\u952e\u76d8\u5df2\u66f4\u65b0\uff0c\u9884\u8bbe\u53f7\u7801\u53f7\u7801\uff1a" + keyboard.presetNumber + "\uff0c\u6700\u7ec8\u63a2\u6d4b\u7c7b\u578b\uff1a" + (Object)((Object)keyboard.currentNumberType)));
                }
                KeyboardInputController.this.updateInputViewItemsByNumberType(keyboard.currentNumberType);
            }
        };
    }

    @Deprecated
    public static class ButtonProxy
    extends ButtonProxyImpl {
        public ButtonProxy(Button button) {
            super(button);
        }
    }

    public static class ButtonProxyImpl
    implements LockNewEnergyProxy {
        private final Button mButton;

        public ButtonProxyImpl(Button button) {
            this.mButton = button;
        }

        @Override
        public void setOnClickListener(View.OnClickListener listener) {
            this.mButton.setOnClickListener(listener);
        }

        @Override
        public void onNumberTypeChanged(boolean isNewEnergyType) {
            if (isNewEnergyType) {
                this.mButton.setText(R.string.pwk_change_to_normal);
            } else {
                this.mButton.setText(R.string.pwk_change_to_energy);
            }
        }
    }

    @Deprecated
    public static interface LockTypeProxy
    extends LockNewEnergyProxy {
    }

    public static interface LockNewEnergyProxy {
        public void setOnClickListener(View.OnClickListener var1);

        public void onNumberTypeChanged(boolean var1);
    }
}

