/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.vehiclekeyboard;

import android.app.Activity;
import android.content.Context;
import com.parkingwang.vehiclekeyboard.KeyboardInputController;
import com.parkingwang.vehiclekeyboard.support.PopupHelper;
import com.parkingwang.vehiclekeyboard.view.InputView;
import com.parkingwang.vehiclekeyboard.view.KeyboardView;

public class PopupKeyboard {
    private final KeyboardView mKeyboardView;
    private KeyboardInputController mController;

    public PopupKeyboard(Context context) {
        this.mKeyboardView = new KeyboardView(context);
    }

    public KeyboardView getKeyboardView() {
        return this.mKeyboardView;
    }

    public void attach(InputView inputView, final Activity activity) {
        if (this.mController == null) {
            this.mController = KeyboardInputController.with(this.mKeyboardView, inputView);
            this.mController.useDefaultMessageHandler();
            inputView.addOnItemSelectedListener(new InputView.OnItemSelectedListener(){

                @Override
                public void onSelected(int index) {
                    PopupKeyboard.this.show(activity);
                }
            });
        }
    }

    public KeyboardInputController getController() {
        return this.checkAttachedController();
    }

    public void show(Activity activity) {
        this.checkAttachedController();
        PopupHelper.showToActivity(activity, this.mKeyboardView);
    }

    public void dismiss(Activity activity) {
        this.checkAttachedController();
        PopupHelper.dismissFromActivity(activity);
    }

    public boolean isShown() {
        return this.mKeyboardView.isShown();
    }

    private KeyboardInputController checkAttachedController() {
        if (this.mController == null) {
            throw new IllegalStateException("Try attach() first");
        }
        return this.mController;
    }
}

