/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.vehiclekeyboard.support;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;
import com.annimon.stream.Collectors;
import com.annimon.stream.Stream;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.Predicate;
import com.parkingwang.vehiclekeyboard.R;
import com.parkingwang.vehiclekeyboard.core.KeyEntry;
import com.parkingwang.vehiclekeyboard.core.KeyboardEntry;
import com.parkingwang.vehiclekeyboard.core.NumberType;
import com.parkingwang.vehiclekeyboard.support.MessageHandler;
import com.parkingwang.vehiclekeyboard.support.OnInputChangedListener;
import com.parkingwang.vehiclekeyboard.support.OnNumberTypeChangedListener;
import com.parkingwang.vehiclekeyboard.support.Texts;
import com.parkingwang.vehiclekeyboard.view.InputView;
import com.parkingwang.vehiclekeyboard.view.KeyboardCallback;
import com.parkingwang.vehiclekeyboard.view.KeyboardView;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class KeyboardInputController {
    private static final String TAG = "KeyboardInputController";
    private final KeyboardView mKeyboardView;
    private final InputView mInputView;
    private final Set<OnInputChangedListener> mOnInputChangedListeners = new LinkedHashSet<OnInputChangedListener>(4);
    private final Set<OnNumberTypeChangedListener> mOnNumberTypeChangedListeners = new LinkedHashSet<OnNumberTypeChangedListener>(4);
    private NumberType mCurrentNumberType = NumberType.AUTO_DETECT;
    private boolean mLockedOnNewEnergyType = false;
    private boolean mDebugEnabled = true;
    private MessageHandler mMessageHandler;

    public static KeyboardInputController with(KeyboardView keyboardView, InputView inputView) {
        return new KeyboardInputController(keyboardView, inputView);
    }

    private KeyboardInputController(KeyboardView keyboardView, InputView inputView) {
        this.mKeyboardView = keyboardView;
        this.mInputView = inputView;
        this.mInputView.addOnItemSelectedListener(new InputView.OnItemSelectedListener(){

            @Override
            public void onSelected(int index) {
                String number = KeyboardInputController.this.mInputView.getNumber();
                if (KeyboardInputController.this.mDebugEnabled) {
                    Log.w((String)KeyboardInputController.TAG, (String)("\u70b9\u51fb\u8f93\u5165\u6846\u66f4\u65b0\u952e\u76d8, \u53f7\u7801\uff1a" + number + "\uff0c\u5e8f\u53f7\uff1a" + index));
                }
                KeyboardInputController.this.mKeyboardView.update(number, index, KeyboardInputController.this.mCurrentNumberType);
            }
        });
        this.mKeyboardView.addKeyboardCallback(this.syncKeyboardInputState());
        this.mKeyboardView.addKeyboardCallback(this.triggerAutoCommit());
        this.mKeyboardView.addKeyboardCallback(this.triggerInputChangedCallback());
    }

    public KeyboardInputController bindLockTypeProxy(final LockNewEnergyProxy proxy) {
        proxy.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                KeyboardInputController.this.tryLockNewEnergyType(!KeyboardInputController.this.mLockedOnNewEnergyType);
            }
        });
        this.mKeyboardView.addKeyboardCallback(new KeyboardCallback.Simple(){

            @Override
            public void onUpdateKeyboard(KeyboardEntry keyboard) {
                if (NumberType.NEW_ENERGY.equals((Object)keyboard.detectedNumberType)) {
                    KeyboardInputController.this.tryLockNewEnergyType(true);
                }
                KeyboardInputController.this.changeNumberType(keyboard.detectedNumberType);
            }
        });
        this.addOnNumberTypeChangedListener(new OnNumberTypeChangedListener(){

            @Override
            public void onChanged(NumberType currentType) {
                proxy.onNumberTypeChanged(NumberType.NEW_ENERGY.equals((Object)currentType));
            }
        });
        return this;
    }

    public KeyboardInputController useDefaultMessageHandler() {
        return this.setMessageHandler(new MessageHandler(){

            @Override
            public void onMessageError(int message) {
                Toast.makeText((Context)KeyboardInputController.this.mKeyboardView.getContext(), (int)message, (int)0).show();
            }

            @Override
            public void onMessageTip(int message) {
                Toast.makeText((Context)KeyboardInputController.this.mKeyboardView.getContext(), (int)message, (int)0).show();
            }
        });
    }

    public KeyboardInputController setMessageHandler(MessageHandler handler) {
        this.mMessageHandler = handler;
        return this;
    }

    public KeyboardInputController addOnNumberTypeChangedListener(OnNumberTypeChangedListener listener) {
        this.mOnNumberTypeChangedListeners.add(listener);
        return this;
    }

    public KeyboardInputController removeOnNumberTypeChangedListener(OnNumberTypeChangedListener listener) {
        this.mOnNumberTypeChangedListeners.remove(listener);
        return this;
    }

    public KeyboardInputController addOnInputChangedListener(OnInputChangedListener listener) {
        this.mOnInputChangedListeners.add(listener);
        return this;
    }

    public KeyboardInputController removeOnInputChangedListener(OnInputChangedListener listener) {
        this.mOnInputChangedListeners.remove(listener);
        return this;
    }

    public KeyboardInputController setDebugEnabled(boolean enabled) {
        this.mDebugEnabled = enabled;
        return this;
    }

    public void updateNumber(String number) {
        this.updateNumberLockType(number, false);
    }

    public void updateNumberLockType(String number, boolean lockedOnNewEnergyType) {
        String newNumber = number == null ? "" : number;
        this.mCurrentNumberType = NumberType.AUTO_DETECT;
        this.mLockedOnNewEnergyType = lockedOnNewEnergyType;
        this.mInputView.updateNumber(newNumber);
        this.mInputView.performLastItem();
    }

    private void updateInputViewItemsByNumberType(NumberType type) {
        this.changeNumberType(type);
        if (NumberType.NEW_ENERGY.equals((Object)type) || NumberType.WUJING_LOCAL.equals((Object)type) || this.mLockedOnNewEnergyType) {
            this.mInputView.set8thItemVisibility(true, false);
        } else {
            this.mInputView.set8thItemVisibility(false, !this.mInputView.isCompleted());
        }
    }

    private void tryLockNewEnergyType(boolean toLock) {
        if (toLock == this.mLockedOnNewEnergyType) {
            return;
        }
        boolean completed = this.mInputView.isCompleted();
        if (toLock) {
            this.triggerLockEnergyType(completed);
        } else {
            this.triggerUnlockEnergy(completed);
        }
    }

    private void triggerUnlockEnergy(boolean completed) {
        this.mLockedOnNewEnergyType = false;
        this.mMessageHandler.onMessageTip(R.string.pwk_now_is_normal);
        boolean lastItemSelected = this.mInputView.isLastItemSelected();
        this.updateInputViewItemsByNumberType(NumberType.AUTO_DETECT);
        if (completed || lastItemSelected) {
            this.mInputView.performLastItem();
        } else {
            this.mInputView.performCurrentItem();
        }
    }

    private void triggerLockEnergyType(boolean completed) {
        if (NumberType.NEW_ENERGY.equals((Object)this.mCurrentNumberType) || Texts.isNewEnergyType(this.mInputView.getNumber())) {
            this.mLockedOnNewEnergyType = true;
            this.mMessageHandler.onMessageTip(R.string.pwk_now_is_energy);
            this.updateInputViewItemsByNumberType(NumberType.NEW_ENERGY);
            if (completed) {
                this.mInputView.performNextItem();
            } else {
                this.mInputView.performCurrentItem();
            }
        } else {
            this.mMessageHandler.onMessageError(R.string.pwk_change_to_energy_disallow);
        }
    }

    private KeyboardCallback triggerInputChangedCallback() {
        return new KeyboardCallback.Simple(){

            @Override
            public void onTextKey(String text) {
                this.notifyChanged();
            }

            @Override
            public void onDeleteKey() {
                this.notifyChanged();
            }

            @Override
            public void onConfirmKey() {
                String number = KeyboardInputController.this.mInputView.getNumber();
                for (OnInputChangedListener listener : KeyboardInputController.this.mOnInputChangedListeners) {
                    listener.onCompleted(number, false);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void notifyChanged() {
                boolean completed = KeyboardInputController.this.mInputView.isCompleted();
                String number = KeyboardInputController.this.mInputView.getNumber();
                try {
                    for (OnInputChangedListener listener : KeyboardInputController.this.mOnInputChangedListeners) {
                        listener.onChanged(number, completed);
                    }
                }
                finally {
                    if (completed) {
                        for (OnInputChangedListener listener : KeyboardInputController.this.mOnInputChangedListeners) {
                            listener.onCompleted(number, true);
                        }
                    }
                }
            }
        };
    }

    private KeyboardCallback triggerAutoCommit() {
        return new KeyboardCallback.Simple(){
            private boolean mIsDeleteAction = false;

            @Override
            public void onTextKey(String text) {
                this.mIsDeleteAction = false;
            }

            @Override
            public void onDeleteKey() {
                this.mIsDeleteAction = true;
            }

            @Override
            public void onUpdateKeyboard(KeyboardEntry keyboard) {
                List keys;
                if (!(1 != keyboard.index && 6 != keyboard.index || this.mIsDeleteAction || (keys = (List)Stream.of(keyboard.keyRows).flatMap((Function)new Function<List<KeyEntry>, Stream<KeyEntry>>(){

                    public Stream<KeyEntry> apply(List<KeyEntry> entries) {
                        return Stream.of(entries);
                    }
                }).filter((Predicate)new Predicate<KeyEntry>(){

                    public boolean test(KeyEntry key) {
                        return !key.isFunKey && key.enabled;
                    }
                }).collect(Collectors.toList())).size() != 1)) {
                    KeyboardInputController.this.mInputView.updateSelectedCharAndSelectNext(((KeyEntry)keys.get((int)0)).text);
                }
            }
        };
    }

    private KeyboardCallback syncKeyboardInputState() {
        return new KeyboardCallback.Simple(){

            @Override
            public void onTextKey(String text) {
                KeyboardInputController.this.mInputView.updateSelectedCharAndSelectNext(text);
            }

            @Override
            public void onDeleteKey() {
                KeyboardInputController.this.mInputView.removeLastCharOfNumber();
            }

            @Override
            public void onUpdateKeyboard(KeyboardEntry keyboard) {
                if (KeyboardInputController.this.mDebugEnabled) {
                    Log.w((String)KeyboardInputController.TAG, (String)("\u952e\u76d8\u5df2\u66f4\u65b0\uff0c\u9884\u8bbe\u53f7\u7801\u53f7\u7801\uff1a" + keyboard.presetNumber + "\uff0c\u9884\u8bbe\u53f7\u7801\u7c7b\u578b\uff1a" + (Object)((Object)keyboard.presetNumberType) + "\uff0c\u6700\u7ec8\u63a2\u6d4b\u7c7b\u578b\uff1a" + (Object)((Object)keyboard.detectedNumberType)));
                }
                KeyboardInputController.this.updateInputViewItemsByNumberType(keyboard.detectedNumberType);
            }
        };
    }

    private void changeNumberType(NumberType willType) {
        this.mCurrentNumberType = this.mLockedOnNewEnergyType ? NumberType.NEW_ENERGY : willType;
        for (OnNumberTypeChangedListener listener : this.mOnNumberTypeChangedListeners) {
            listener.onChanged(this.mCurrentNumberType);
        }
    }

    @Deprecated
    public static class ButtonProxy
    extends ButtonProxyImpl {
        public ButtonProxy(Button button) {
            super(button);
        }
    }

    public static class ButtonProxyImpl
    implements LockNewEnergyProxy {
        private final Button mButton;

        public ButtonProxyImpl(Button button) {
            this.mButton = button;
        }

        @Override
        public void setOnClickListener(View.OnClickListener listener) {
            this.mButton.setOnClickListener(listener);
        }

        @Override
        public void onNumberTypeChanged(boolean isNewEnergyType) {
            if (isNewEnergyType) {
                this.mButton.setText(R.string.pwk_change_to_normal);
            } else {
                this.mButton.setText(R.string.pwk_change_to_energy);
            }
        }
    }

    @Deprecated
    public static interface LockTypeProxy
    extends LockNewEnergyProxy {
    }

    public static interface LockNewEnergyProxy {
        public void setOnClickListener(View.OnClickListener var1);

        public void onNumberTypeChanged(boolean var1);
    }
}

