/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.vehiclekeyboard.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.widget.LinearLayout;
import com.annimon.stream.Stream;
import com.annimon.stream.function.Consumer;
import com.parkingwang.vehiclekeyboard.R;
import com.parkingwang.vehiclekeyboard.core.EngineRunner;
import com.parkingwang.vehiclekeyboard.core.KeyEntry;
import com.parkingwang.vehiclekeyboard.core.KeyType;
import com.parkingwang.vehiclekeyboard.core.KeyboardEntry;
import com.parkingwang.vehiclekeyboard.core.KeyboardType;
import com.parkingwang.vehiclekeyboard.core.NumberType;
import com.parkingwang.vehiclekeyboard.support.Texts;
import com.parkingwang.vehiclekeyboard.view.KeyRowLayout;
import com.parkingwang.vehiclekeyboard.view.KeyView;
import com.parkingwang.vehiclekeyboard.view.KeyViewCacheHelper;
import com.parkingwang.vehiclekeyboard.view.KeyboardCallback;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class KeyboardView
extends LinearLayout {
    private static ExecutorService RUNNER_THREAD = Executors.newSingleThreadExecutor();
    private final Paint mDividerPaint = new Paint(5);
    private int mRowSpace;
    private final EngineRunner mEngine;
    private final List<KeyboardCallback> mKeyboardCallbacks = new CopyOnWriteArrayList<KeyboardCallback>();
    private KeyboardType mKeyboardType;
    private int mDefaultKeyHeight;
    private boolean mShowBubble = true;
    private float mCNTextSize;
    private float mENTextSize;
    private MotionEvent mLastEvent;
    private final View.OnClickListener mKeyViewListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (!(v instanceof KeyView)) {
                return;
            }
            KeyView keyView = (KeyView)v;
            final KeyEntry key = keyView.getBoundKey();
            Stream.of((Iterable)KeyboardView.this.mKeyboardCallbacks).forEach((Consumer)new Consumer<KeyboardCallback>(){

                public void accept(KeyboardCallback callback) {
                    if (key.keyType == KeyType.GENERAL) {
                        callback.onTextKey(key.text);
                    } else if (key.keyType == KeyType.DELETE) {
                        callback.onDeleteKey();
                    } else if (key.keyType == KeyType.OK) {
                        callback.onConfirmKey();
                    }
                }
            });
        }
    };
    private final KeyViewCacheHelper mKeyCacheHelper = new KeyViewCacheHelper();

    public KeyboardView(Context context) {
        this(context, null);
    }

    public KeyboardView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.KeyboardView);
        int type = ta.getInt(R.styleable.KeyboardView_pwkKeyboardType, 0);
        ta.recycle();
        Resources resources = this.getResources();
        this.mDefaultKeyHeight = resources.getDimensionPixelSize(R.dimen.pwk_keyboard_key_height);
        this.mEngine = new EngineRunner(context);
        this.mKeyboardType = KeyboardType.values()[type];
        this.setOrientation(1);
        Drawable rowDivider = ContextCompat.getDrawable((Context)context, (int)R.drawable.pwk_space_vertical);
        this.mRowSpace = rowDivider.getIntrinsicHeight();
        this.setDividerDrawable(rowDivider);
        this.setShowDividers(2);
        this.setBackgroundResource(R.color.pwk_keyboard_background);
        int dividerColor = ContextCompat.getColor((Context)context, (int)R.color.pwk_keyboard_divider);
        this.mDividerPaint.setColor(dividerColor);
        int leftPadding = this.getResources().getDimensionPixelSize(R.dimen.pwk_keyboard_padding_left);
        int topPadding = this.getResources().getDimensionPixelSize(R.dimen.pwk_keyboard_padding_top);
        int rightPadding = this.getResources().getDimensionPixelSize(R.dimen.pwk_keyboard_padding_right);
        int bottomPadding = this.getResources().getDimensionPixelSize(R.dimen.pwk_keyboard_padding_bottom);
        this.setPadding(leftPadding, topPadding, rightPadding, bottomPadding);
        this.setClipChildren(false);
        this.setClipToPadding(false);
        this.mCNTextSize = this.getResources().getDimensionPixelSize(R.dimen.pwk_keyboard_key_cn_text_size);
        this.mENTextSize = this.getResources().getDimensionPixelSize(R.dimen.pwk_keyboard_key_en_text_size);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
        this.update("");
    }

    public final void update(@NonNull String number) {
        this.update(number, number.length());
    }

    public final void update(@NonNull String number, int index) {
        this.update(number, index, NumberType.AUTO_DETECT);
    }

    public void update(final @NonNull String number, final int showIndex, final NumberType numberType) {
        final long start = System.nanoTime();
        RUNNER_THREAD.submit(new Runnable(){

            @Override
            public void run() {
                KeyboardView.this.mEngine.start();
                int finalIndex = showIndex < 0 ? 0 : showIndex;
                final KeyboardEntry keyboard = KeyboardView.this.mEngine.update(KeyboardView.this.mKeyboardType, finalIndex, number, numberType);
                long escaped = TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
                KeyboardView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        if (keyboard == null) {
                            return;
                        }
                        try {
                            KeyboardView.this.updateKeyboardLayout(keyboard);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        KeyboardView.this.triggerCallback(keyboard);
                    }
                });
            }
        });
    }

    private void triggerCallback(KeyboardEntry keyboard) {
        try {
            for (KeyboardCallback callback : this.mKeyboardCallbacks) {
                callback.onUpdateKeyboard(keyboard);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateKeyboardLayout(KeyboardEntry keyboard) {
        int maxColumn = 0;
        List<List<KeyEntry>> keyRows = keyboard.keyRows;
        for (List<KeyEntry> row : keyRows) {
            if (row.size() <= maxColumn) continue;
            maxColumn = row.size();
        }
        int rowSize = keyRows.size();
        this.mKeyCacheHelper.recyclerKeyRows(this, rowSize);
        for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
            List<KeyEntry> keyEntryRow = keyRows.get(rowIndex);
            KeyRowLayout rowLayout = (KeyRowLayout)this.getChildAt(rowIndex);
            rowLayout.setMaxColumn(maxColumn);
            int columnSize = keyEntryRow.size();
            int funKeyCount = 0;
            for (KeyEntry keyEntry : keyEntryRow) {
                if (!keyEntry.isFunKey) continue;
                ++funKeyCount;
            }
            rowLayout.setFunKeyCount(funKeyCount);
            this.mKeyCacheHelper.recyclerKeyViewsInRow(rowLayout, columnSize, this.mKeyViewListener);
            int size = keyEntryRow.size();
            for (int i = 0; i < size; ++i) {
                KeyEntry key = keyEntryRow.get(i);
                KeyView keyView = (KeyView)rowLayout.getChildAt(i);
                keyView.bindKey(key);
                if (key.keyType == KeyType.DELETE) {
                    keyView.setText("");
                } else {
                    keyView.setText(key.text);
                }
                if (Texts.isLetterOrDigitOnly(key.text)) {
                    keyView.setTextSize(0, this.mENTextSize);
                } else {
                    keyView.setTextSize(0, this.mCNTextSize);
                }
                keyView.setShowBubble(this.mShowBubble);
                keyView.setEnabled(key.enabled);
            }
        }
    }

    public void setKeyboardType(@NonNull KeyboardType keyboardType) {
        this.mKeyboardType = keyboardType;
    }

    public void addKeyboardCallback(@NonNull KeyboardCallback callback) {
        this.mKeyboardCallbacks.add(callback);
    }

    public void removeKeyboardCallback(@NonNull KeyboardCallback callback) {
        this.mKeyboardCallbacks.remove(callback);
    }

    public void setCNTextSize(float textSize) {
        this.setCNTextSize(2, textSize);
    }

    public void setCNTextSize(int unit, float textSize) {
        this.mCNTextSize = TypedValue.applyDimension((int)unit, (float)textSize, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setENTextSize(float textSize) {
        this.setENTextSize(2, textSize);
    }

    public void setENTextSize(int unit, float textSize) {
        this.mENTextSize = TypedValue.applyDimension((int)unit, (float)textSize, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setShowBubble(boolean showBubble) {
        this.mShowBubble = showBubble;
    }

    public void start() {
        RUNNER_THREAD.submit(new Runnable(){

            @Override
            public void run() {
                KeyboardView.this.mEngine.start();
            }
        });
    }

    public void stop() {
        RUNNER_THREAD.submit(new Runnable(){

            @Override
            public void run() {
                KeyboardView.this.mEngine.stop();
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.start();
    }

    protected void onDetachedFromWindow() {
        this.stop();
        super.onDetachedFromWindow();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int rows = this.getChildCount();
        if (heightMode == Integer.MIN_VALUE) {
            height = rows * this.mDefaultKeyHeight + (rows - 1) * this.mRowSpace + this.getPaddingTop() + this.getPaddingBottom();
            for (int i = 0; i < rows; ++i) {
                this.getChildAt((int)i).getLayoutParams().height = this.mDefaultKeyHeight;
            }
        } else if (heightMode == 0x40000000 && rows > 0) {
            int childHeight = (height - this.getPaddingTop() - this.getPaddingBottom() - (rows - 1) * this.mRowSpace) / rows;
            for (int i = 0; i < rows; ++i) {
                this.getChildAt((int)i).getLayoutParams().height = childHeight;
            }
        }
        super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), 2.0f, this.mDividerPaint);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getPointerCount() > 1 && ev.getActionMasked() == 5) {
            float x = ev.getX(ev.getActionIndex());
            float y = ev.getY(ev.getActionIndex());
            if (this.mLastEvent != null && x >= 0.0f && x < (float)this.getWidth() && y >= 0.0f && y <= (float)this.getHeight()) {
                MotionEvent cancelEvent = MotionEvent.obtain((long)this.mLastEvent.getDownTime(), (long)this.mLastEvent.getEventTime(), (int)1, (float)this.mLastEvent.getX(), (float)this.mLastEvent.getY(), (int)this.mLastEvent.getMetaState());
                super.dispatchTouchEvent(cancelEvent);
                if (cancelEvent != null) {
                    cancelEvent.recycle();
                }
                return true;
            }
        }
        this.mLastEvent = ev;
        return super.dispatchTouchEvent(ev);
    }
}

