/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.environmentmanager.jenkins;

import java.io.IOException;
import java.io.InputStream;

public class ReportScanner
extends InputStream {
    private static final String TOTAL_ELEMENT = "Total";
    private static final String FAIL_ATTRIBUTE = "fail";
    private static final String TOTAL_ATTRIBUTE = "total";
    private boolean captureAttributeName = false;
    private boolean captureElementName = false;
    private boolean insideAttributeValue = false;
    private boolean insideQuotes = false;
    private boolean finished = false;
    private StringBuilder attributeName = new StringBuilder();
    private StringBuilder attributeValue = new StringBuilder();
    private StringBuilder elementName = new StringBuilder();
    private final InputStream wrapped;
    private int failures;
    private int total;

    public ReportScanner(InputStream in) {
        this.wrapped = in;
        this.failures = -1;
        this.total = -1;
    }

    public int getFailureCount() {
        return this.failures;
    }

    public int getTotalCount() {
        return this.total;
    }

    @Override
    public int read() throws IOException {
        int next = this.wrapped.read();
        if (this.finished) {
            return next;
        }
        if (!(this.insideQuotes || next != 47 && next != 62)) {
            this.captureElementName = false;
            if (TOTAL_ELEMENT.equals(this.elementName.toString())) {
                this.finished = true;
            }
            return next;
        }
        if (TOTAL_ELEMENT.equals(this.elementName.toString())) {
            if (this.insideAttributeValue) {
                if (next == 34) {
                    boolean bl = this.insideQuotes = !this.insideQuotes;
                    if (!this.insideQuotes) {
                        this.insideAttributeValue = false;
                        if (FAIL_ATTRIBUTE.equals(this.attributeName.toString())) {
                            try {
                                this.failures = Integer.parseInt(this.attributeValue.toString());
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else if (TOTAL_ATTRIBUTE.equals(this.attributeName.toString())) {
                            try {
                                this.total = Integer.parseInt(this.attributeValue.toString());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        this.attributeValue.setLength(0);
                    }
                } else {
                    this.attributeValue.append((char)next);
                }
            } else if (this.captureAttributeName) {
                if (next == 61) {
                    this.captureAttributeName = false;
                    this.insideAttributeValue = true;
                } else if (Character.isWhitespace(next)) {
                    this.captureAttributeName = false;
                } else {
                    this.attributeName.append((char)next);
                }
            } else if (!Character.isWhitespace(next)) {
                this.captureAttributeName = true;
                this.attributeName.setLength(0);
                this.attributeName.append((char)next);
            }
        }
        if (this.captureElementName) {
            if (Character.isWhitespace(next)) {
                this.captureElementName = false;
            } else {
                this.elementName.append((char)next);
            }
        } else if (next == 60) {
            this.captureElementName = true;
            this.elementName.setLength(0);
        }
        return next;
    }

    @Override
    public void close() throws IOException {
        this.wrapped.close();
    }
}

