/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.environmentmanager.jenkins;

import com.parasoft.dtp.client.impl.ServicesImpl;
import com.parasoft.em.client.impl.EnvironmentsImpl;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class EnvironmentManagerPlugin
extends JobProperty<Job<?, ?>> {
    public EnvironmentManagerPluginDescriptor getDescriptor() {
        Jenkins instance = Jenkins.getInstance();
        if (instance == null) {
            return null;
        }
        return (EnvironmentManagerPluginDescriptor)instance.getDescriptor(((Object)((Object)this)).getClass());
    }

    public static EnvironmentManagerPluginDescriptor getEnvironmentManagerPluginDescriptor() {
        Jenkins instance = Jenkins.getInstance();
        if (instance == null) {
            return null;
        }
        return (EnvironmentManagerPluginDescriptor)instance.getDescriptor(EnvironmentManagerPlugin.class);
    }

    @Extension
    public static final class EnvironmentManagerPluginDescriptor
    extends JobPropertyDescriptor {
        private String emUrl;
        private String username;
        private Secret password;
        private String dtpUrl;
        private String dtpUsername;
        private Secret dtpPassword;

        public EnvironmentManagerPluginDescriptor() {
            super(EnvironmentManagerPlugin.class);
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String oldEmUrl = this.emUrl;
            String oldUsername = this.username;
            Secret oldPassword = this.password;
            String oldDtpUrl = this.dtpUrl;
            String oldDtpUsername = this.dtpUsername;
            Secret oldDtpPassword = this.dtpPassword;
            this.emUrl = formData.getString("emUrl");
            this.username = formData.getString("username");
            this.password = Secret.fromString((String)formData.getString("password"));
            this.dtpUrl = formData.getString("dtpUrl");
            this.dtpUsername = formData.getString("dtpUsername");
            this.dtpPassword = Secret.fromString((String)formData.getString("dtpPassword"));
            if (this.emUrl.equals(oldEmUrl) && this.username.equals(oldUsername) && this.password.equals((Object)oldPassword) && this.dtpUrl.equals(oldDtpUrl) && this.dtpUsername.equals(oldDtpUsername) && this.dtpPassword.equals((Object)oldDtpPassword)) {
                return true;
            }
            try {
                EnvironmentsImpl environments = new EnvironmentsImpl(this.emUrl, this.username, this.password.getPlainText());
                environments.getEnvironments();
            }
            catch (IOException e) {
                String testUrl = this.emUrl;
                testUrl = testUrl.endsWith("/") ? testUrl + "em" : testUrl + "/em";
                try {
                    EnvironmentsImpl environments = new EnvironmentsImpl(testUrl, this.username, this.password.getPlainText());
                    environments.getEnvironments();
                    this.emUrl = testUrl;
                }
                catch (IOException e2) {
                    throw new Descriptor.FormException("Unable to connect to the Continuous Testing Platform at " + this.emUrl, "emUrl");
                }
            }
            req.bindJSON((Object)this, formData);
            this.save();
            return super.configure(req, formData);
        }

        @DataBoundConstructor
        public EnvironmentManagerPluginDescriptor(String emUrl, String username, Secret password) {
            this.emUrl = emUrl;
            this.username = username;
            this.password = password;
        }

        public String getDisplayName() {
            return "Parasoft Continuous Testing Platform";
        }

        public String getEmUrl() {
            return this.emUrl;
        }

        public String getUsername() {
            return this.username;
        }

        public Secret getPassword() {
            return this.password;
        }

        public String getDtpUrl() {
            return this.dtpUrl;
        }

        public String getDtpUsername() {
            return this.dtpUsername;
        }

        public Secret getDtpPassword() {
            return this.dtpPassword;
        }

        public FormValidation doTestConnection(@QueryParameter String emUrl, @QueryParameter String username, @QueryParameter String password) {
            boolean emApiV1 = false;
            Secret secret = Secret.fromString((String)password);
            try {
                EnvironmentsImpl environments = new EnvironmentsImpl(emUrl, username, secret.getPlainText());
                environments.getEnvironmentsV1();
                emApiV1 = true;
                environments.getEnvironments();
            }
            catch (IOException e) {
                emUrl = emUrl.endsWith("/") ? emUrl + "em" : emUrl + "/em";
                try {
                    EnvironmentsImpl environments = new EnvironmentsImpl(emUrl, username, secret.getPlainText());
                    environments.getEnvironmentsV1();
                    emApiV1 = true;
                    environments.getEnvironments();
                    return FormValidation.ok((String)"Successfully connected to Continuous Testing Platform");
                }
                catch (IOException iOException) {
                    if (emApiV1) {
                        return FormValidation.error((String)"Continuous Testing Platform version 3.0 or higher is required.");
                    }
                    return FormValidation.error((Throwable)e, (String)"Unable to connect to Continuous Testing Platform");
                }
            }
            return FormValidation.ok((String)"Successfully connected to Continuous Testing Platform");
        }

        public FormValidation doDtpTestConnection(@QueryParameter String dtpUrl, @QueryParameter String dtpUsername, @QueryParameter String dtpPassword) {
            Secret secret = Secret.fromString((String)dtpPassword);
            try {
                ServicesImpl services = new ServicesImpl(dtpUrl, dtpUsername, secret.getPlainText());
                services.getServices();
            }
            catch (IOException e) {
                return FormValidation.error((Throwable)e, (String)"Unable to connect to DTP");
            }
            return FormValidation.ok((String)"Successfully connected to DTP");
        }
    }
}

