/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.environmentmanager.jenkins;

import com.parasoft.em.client.impl.ServersImpl;
import com.parasoft.environmentmanager.jenkins.EnvironmentManagerPlugin;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.Secret;
import java.io.IOException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class DeleteVirtualizeBuilder
extends Builder {
    private String serverType;
    private String serverHost;
    private String serverName;

    @DataBoundConstructor
    public DeleteVirtualizeBuilder(String serverType, String serverHost, String serverName) {
        this.serverType = serverType;
        this.serverHost = serverHost;
        this.serverName = serverName;
    }

    public boolean isServerType(String type) {
        if (this.serverType == null || this.serverType.isEmpty()) {
            return "host".equals(type);
        }
        return this.serverType.equals(type);
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        EnvironmentManagerPlugin.EnvironmentManagerPluginDescriptor pluginDescriptor = EnvironmentManagerPlugin.getEnvironmentManagerPluginDescriptor();
        String emUrl = pluginDescriptor.getEmUrl();
        String username = pluginDescriptor.getUsername();
        Secret password = pluginDescriptor.getPassword();
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        String hostToDelete = envVars.expand(this.serverHost);
        String nameToDelete = envVars.expand(this.serverName);
        ServersImpl servers = new ServersImpl(emUrl, username, password.getPlainText());
        JSONObject serversJSON = servers.getServers();
        JSONArray serversJSONArray = serversJSON.getJSONArray("servers");
        boolean error = false;
        boolean match = false;
        for (int i = 0; i < serversJSONArray.size(); ++i) {
            try {
                JSONObject serverJSON = serversJSONArray.getJSONObject(i);
                if (this.isServerType("host") && !serverJSON.getString("host").equals(hostToDelete) || this.isServerType("name") && !serverJSON.getString("name").equals(nameToDelete)) continue;
                match = true;
                listener.getLogger().println("Disconnecting Virtualize server \"" + serverJSON.getString("name") + "\" (" + serverJSON.getString("host") + ':' + serverJSON.getInt("port") + ")...");
                servers.deleteServer(serverJSON.getLong("id"));
                continue;
            }
            catch (IOException e) {
                listener.getLogger().println(e.getMessage());
                error = true;
            }
        }
        if (!match) {
            if (this.isServerType("host")) {
                listener.getLogger().println("No Virtualize servers match host:  " + hostToDelete);
            }
            if (this.isServerType("name")) {
                listener.getLogger().println("No Virtualize servers match name:  " + nameToDelete);
            }
        }
        return match && !error;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Disconnect a Virtualize server";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindJSON((Object)this, json);
            this.save();
            return super.configure(req, json);
        }
    }
}

