/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.em.client.impl;

import com.parasoft.em.client.api.EventMonitor;
import com.parasoft.em.client.api.Provisions;
import com.parasoft.em.client.impl.EnvironmentsImpl;
import com.parasoft.em.client.impl.JSONClient;
import com.parasoft.em.client.impl.SystemsImpl;
import java.io.IOException;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class ProvisionsImpl
extends JSONClient
implements Provisions {
    public ProvisionsImpl(String emUrl, String username, String password) {
        super(emUrl, username, password);
    }

    @Override
    public JSONObject createProvisionEvent(int environmentId, int instanceId, boolean abortOnFailure) throws IOException {
        JSONObject payload = new JSONObject();
        try {
            payload.put((Object)"environmentId", (Object)environmentId);
            payload.put((Object)"instanceId", (Object)instanceId);
            payload.put((Object)"abortOnFailure", (Object)abortOnFailure);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this.doPost("api/v1/provisions", payload);
    }

    @Override
    public JSONObject getProvisions() throws IOException {
        return this.doGet("api/v1/provisions", true);
    }

    @Override
    public JSONObject getProvisions(int id) throws IOException {
        return this.doGet("api/v1/provisions/" + id);
    }

    @Override
    public boolean monitorEvent(JSONObject event, EventMonitor monitor) throws IOException {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SystemsImpl systems = new SystemsImpl(this.baseUrl, this.username, this.password);
        EnvironmentsImpl environments = new EnvironmentsImpl(this.baseUrl, this.username, this.password);
        int eventId = event.getInt("eventId");
        int environmentId = event.getInt("environmentId");
        int instanceId = event.getInt("instanceId");
        JSONObject environment = environments.getEnvironment(environmentId);
        int systemId = environment.getInt("systemId");
        JSONObject system = systems.getSystem(systemId);
        JSONObject instance = environments.getEnvironmentInstance(environmentId, instanceId);
        monitor.logMessage("System: " + system.getString("name"));
        monitor.logMessage("Environment: " + environment.getString("name"));
        monitor.logMessage("Environment Instance: " + instance.getString("name"));
        monitor.logMessage("Provisioning event id: " + eventId);
        boolean failed = false;
        JSONObject response = this.getProvisions(eventId);
        JSONArray steps = response.getJSONArray("steps");
        for (int i = 0; i < steps.size(); ++i) {
            JSONObject step = this.getProvisions(eventId).getJSONArray("steps").getJSONObject(i);
            monitor.logMessage("Running step #" + (i + 1));
            String result = step.getString("result");
            String lastPercent = "";
            while ("running".equals(result)) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                String percent = step.getString("percent");
                if (!lastPercent.equals(percent)) {
                    monitor.logMessage(percent + "%");
                    lastPercent = percent;
                }
                step = this.getProvisions(eventId).getJSONArray("steps").getJSONObject(i);
                result = step.getString("result");
                failed |= "error".equals(result);
            }
        }
        monitor.logMessage("Completed provisioning event with id: " + eventId);
        monitor.logMessage("Access endpoints via REST API GET " + this.baseUrl + "api/v2/environments/" + event.getInt("environmentId") + "/endpoints");
        monitor.logMessage("See " + this.baseUrl + "environments/" + event.getInt("environmentId") + " for details");
        return !failed;
    }
}

