/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.em.client.impl;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.codec.binary.Base64;

public class JSONClient {
    private static int DEFAULT_LIMIT = 50;
    protected static final int ONE_MINUTE = 60000;
    protected static final int FIVE_MINUTES = 300000;
    protected String baseUrl;
    protected String username;
    protected String password;
    protected SSLSocketFactory trustAllSslSocketFactory;

    public JSONClient(String baseUrl, String username, String password) {
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        this.baseUrl = baseUrl;
        this.username = username;
        this.password = password;
        if (this.password != null && this.password.length() == 0) {
            this.password = null;
        }
        this.trustAllSslSocketFactory = null;
    }

    private HttpURLConnection getConnection(String restPath) throws IOException {
        URL url = new URL(this.baseUrl + restPath);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (connection instanceof HttpsURLConnection) {
            HostnameVerifier hostnameVerifier = null;
            try {
                if (this.trustAllSslSocketFactory == null) {
                    this.trustAllSslSocketFactory = JSONClient.makeTrustAllSslSocketFactory();
                }
                hostnameVerifier = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
                ((HttpsURLConnection)connection).setSSLSocketFactory(this.trustAllSslSocketFactory);
                ((HttpsURLConnection)connection).setHostnameVerifier(hostnameVerifier);
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
        }
        connection.setDoOutput(true);
        connection.setRequestProperty("Accept", "application/json");
        if (this.username != null) {
            String encoding = this.username + ":" + this.password;
            encoding = Base64.encodeBase64String((byte[])encoding.getBytes("UTF-8"));
            connection.setRequestProperty("Authorization", "Basic " + encoding);
        }
        connection.setConnectTimeout(60000);
        connection.setReadTimeout(300000);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject getResponseJSON(InputStream stream) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        try {
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
            JSONObject jSONObject = (JSONObject)JSONSerializer.toJSON((Object)result.toString());
            return jSONObject;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            in.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponseString(InputStream stream) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        try {
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
            String string = result.toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    protected JSONObject doGet(String restPath, boolean returnsArray) throws IOException {
        return this.doGet(restPath, "", returnsArray);
    }

    protected JSONObject doGet(String restPath) throws IOException {
        HttpURLConnection connection = this.getConnection(restPath);
        connection.setRequestMethod("GET");
        return this.handleResponse(restPath, connection);
    }

    protected JSONObject doGet(String restPath, String parameter, boolean returnsArray) throws IOException {
        if (returnsArray) {
            JSONObject result;
            int offset = 0;
            JSONObject iterativeResult = result = this.doGet(this.addOffset(restPath, offset, parameter));
            while (this.countTopLevelItems(iterativeResult) == DEFAULT_LIMIT) {
                iterativeResult = this.doGet(this.addOffset(restPath, offset += DEFAULT_LIMIT, parameter));
                this.appendResults(iterativeResult, result);
            }
            return result;
        }
        if (!parameter.isEmpty()) {
            return this.doGet(restPath + "?" + parameter);
        }
        return this.doGet(restPath);
    }

    private String addOffset(String path, int offset, String parameter) {
        String result = path + "?limit=" + DEFAULT_LIMIT + "&offset=" + offset;
        if (!parameter.isEmpty()) {
            result = result + "&" + parameter;
        }
        return result;
    }

    private int countTopLevelItems(JSONObject obj) {
        Object rootItem;
        if (obj.values().size() == 1 && (rootItem = obj.values().iterator().next()) instanceof JSONArray) {
            JSONArray array = (JSONArray)rootItem;
            return array.size();
        }
        return obj.values().size();
    }

    private void appendResults(JSONObject source, JSONObject dest) {
        if (dest.values().size() == 1) {
            Set entries = dest.entrySet();
            Map.Entry entry = (Map.Entry)entries.iterator().next();
            String name = (String)entry.getKey();
            JSONArray array = (JSONArray)entry.getValue();
            array.addAll((Collection)source.getJSONArray(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONObject doPost(String restPath, JSONObject payload) throws IOException {
        HttpURLConnection connection = this.getConnection(restPath);
        connection.setRequestMethod("POST");
        if (payload != null) {
            String payloadString = payload.toString();
            connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            BufferedOutputStream stream = new BufferedOutputStream(connection.getOutputStream());
            try {
                byte[] bytes = payloadString.getBytes("UTF-8");
                stream.write(bytes, 0, bytes.length);
            }
            finally {
                stream.close();
            }
        }
        return this.handleResponse(restPath, connection);
    }

    protected JSONObject doDelete(String restPath) throws IOException {
        HttpURLConnection connection = this.getConnection(restPath);
        connection.setRequestMethod("DELETE");
        return this.handleResponse(restPath, connection);
    }

    private JSONObject handleResponse(String restPath, HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        if (responseCode / 100 == 2) {
            return this.getResponseJSON(connection.getInputStream());
        }
        String errorMessage = this.getResponseString(connection.getErrorStream());
        try {
            JSONObject errorJSON = (JSONObject)JSONSerializer.toJSON((Object)errorMessage);
            if (errorJSON.has("message")) {
                errorMessage = errorJSON.getString("message");
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        throw new IOException(restPath + ' ' + responseCode + '\n' + errorMessage);
    }

    protected static SSLSocketFactory makeTrustAllSslSocketFactory() throws GeneralSecurityException, IOException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, trustAllCerts, new SecureRandom());
        return context.getSocketFactory();
    }
}

