/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.dtp.client.impl;

import com.parasoft.dtp.client.api.Projects;
import com.parasoft.dtp.client.impl.DTPClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class ProjectsImpl
extends DTPClient
implements Projects {
    public ProjectsImpl(String dtpUrl, String username, String password) {
        super(dtpUrl, username, password);
    }

    @Override
    public List<JSONObject> getProjects() throws IOException {
        JSONArray projArray = this.doGetArray("api/v1.6/projects?active=true&managedOnly=true");
        int size = projArray.size();
        ArrayList<JSONObject> result = new ArrayList<JSONObject>(projArray.size());
        for (int i = 0; i < size; ++i) {
            result.add(projArray.getJSONObject(i));
        }
        Collections.sort(result, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                return o1.getString("name").compareToIgnoreCase(o2.getString("name"));
            }
        });
        return result;
    }

    @Override
    public JSONObject getProject(long id) throws IOException {
        return this.doGet("api/v1.6/projects/" + id);
    }
}

