/*
 * Decompiled with CFR 0.152.
 */
package papyrus.util;

import android.app.Activity;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.NonNull;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PapyrusUtil {
    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public static <E> List<E> combine(List<? extends E> ... lists) {
        void var5_8;
        int finalSize = 0;
        for (List<E> list : lists) {
            finalSize += list.size();
        }
        ArrayList<? extends E> result = new ArrayList<E>(finalSize);
        List<? extends E>[] listArray = lists;
        int n = listArray.length;
        boolean bl = false;
        while (var5_8 < n) {
            List<? extends E> list = listArray[var5_8];
            result.addAll(list);
            ++var5_8;
        }
        return result;
    }

    public static void close(Closeable closable) {
        try {
            if (closable != null) {
                if (OutputStream.class.isAssignableFrom(closable.getClass())) {
                    ((OutputStream)closable).flush();
                }
                closable.close();
            }
        }
        catch (IOException e) {
            Log.w((String)"PapyrusUtil", (String)"Failed Closing");
        }
    }

    public static void dismissKeyboard(@NonNull View view) {
        try {
            ((InputMethodManager)view.getContext().getSystemService("input_method")).hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
        catch (NullPointerException e) {
            Log.w((String)"PapyrusUtil", (String)"Could not dismiss keyboard");
        }
    }

    public static boolean is_translucent(Activity activity) {
        TypedValue value = new TypedValue();
        activity.getTheme().resolveAttribute(16842840, value, true);
        return "true".equals(value.coerceToString());
    }
}

