/*
 * Decompiled with CFR 0.152.
 */
package papyrus.util;

import android.support.annotation.NonNull;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class WeakDelegate {
    public static <T> T of(@NonNull T t) {
        final WeakReference<T> tRef = new WeakReference<T>(t);
        return (T)Proxy.newProxyInstance(t.getClass().getClassLoader(), t.getClass().getInterfaces(), new InvocationHandler(){

            @Override
            public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
                Object t = tRef.get();
                if (t != null) {
                    return method.invoke(t, objects);
                }
                Class<?> returnType = method.getReturnType();
                if (!returnType.isPrimitive()) {
                    return null;
                }
                if (returnType == Boolean.TYPE) {
                    return false;
                }
                return 0;
            }
        });
    }

    public static <T> T dummy(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
                return null;
            }
        });
    }
}

