/*
 * Decompiled with CFR 0.152.
 */
package papyrus.util;

import java.util.Calendar;
import java.util.Date;

public class DateDelta {
    public boolean isFuture;
    public int years;
    public int months;
    public int days;
    public int hours;
    public int minutes;
    public int seconds;

    public static DateDelta create(Calendar from, Calendar to) {
        DateDelta delta = new DateDelta();
        int comparison = to.compareTo(from);
        if (comparison == 0) {
            return delta;
        }
        if (comparison < 0) {
            Calendar temp = from;
            from = to;
            to = temp;
            delta.isFuture = true;
        }
        delta.years = to.get(1) - from.get(1);
        delta.months = to.get(2) - from.get(2);
        delta.days = to.get(5) - from.get(5);
        delta.hours = to.get(11) - from.get(11);
        delta.minutes = to.get(12) - from.get(12);
        delta.seconds = to.get(13) - from.get(13);
        if (delta.seconds < 0) {
            --delta.minutes;
            delta.seconds += from.getActualMaximum(13);
        }
        if (delta.minutes < 0) {
            --delta.hours;
            delta.minutes += from.getActualMaximum(12);
        }
        if (delta.hours < 0) {
            --delta.days;
            delta.hours += from.getActualMaximum(10);
        }
        if (delta.days < 0) {
            --delta.months;
            delta.days += from.getActualMaximum(5);
        }
        if (delta.months < 0) {
            --delta.years;
            delta.months += from.getActualMaximum(2);
        }
        return delta;
    }

    public static DateDelta create(Date fromDate, Date toDate) {
        Calendar from = Calendar.getInstance();
        Calendar to = Calendar.getInstance();
        from.setTime(fromDate);
        to.setTime(toDate);
        return DateDelta.create(from, to);
    }
}

