/*
 * Decompiled with CFR 0.152.
 */
package papyrus.pager;

import android.util.SparseArray;
import androidx.annotation.CallSuper;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStatePagerAdapter;
import androidx.viewpager.widget.ViewPager;
import java.lang.ref.WeakReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import papyrus.pager.PageItem;
import papyrus.pager.iface.IPageCreator;
import papyrus.pager.iface.IPageStateCallback;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010#\u001a\u0004\u0018\u00010\u001eJ\b\u0010$\u001a\u00020\bH\u0016J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\bH\u0016J\u0010\u0010'\u001a\u0004\u0018\u00010\u001e2\u0006\u0010&\u001a\u00020\bJ\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\bH\u0015J\u0010\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020\bH\u0016J \u0010-\u001a\u00020)2\u0006\u0010&\u001a\u00020\b2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\bH\u0016J\u0010\u00101\u001a\u00020)2\u0006\u0010&\u001a\u00020\bH\u0016J\u0006\u00102\u001a\u00020)R \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR&\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u00063"}, d2={"Lpapyrus/pager/PageAdapter;", "Landroidx/fragment/app/FragmentStatePagerAdapter;", "Landroidx/viewpager/widget/ViewPager$OnPageChangeListener;", "fm", "Landroidx/fragment/app/FragmentManager;", "creator", "Lpapyrus/pager/iface/IPageCreator;", "initialPosition", "", "(Landroidx/fragment/app/FragmentManager;Lpapyrus/pager/iface/IPageCreator;I)V", "contents", "", "Lpapyrus/pager/PageItem;", "getContents", "()Ljava/util/List;", "setContents", "(Ljava/util/List;)V", "getCreator", "()Lpapyrus/pager/iface/IPageCreator;", "setCreator", "(Lpapyrus/pager/iface/IPageCreator;)V", "<set-?>", "currentPosition", "getCurrentPosition", "()I", "setCurrentPosition", "(I)V", "fragments", "Landroid/util/SparseArray;", "Ljava/lang/ref/WeakReference;", "Landroidx/fragment/app/Fragment;", "getFragments", "()Landroid/util/SparseArray;", "setFragments", "(Landroid/util/SparseArray;)V", "currentFragment", "getCount", "getItem", "position", "getItemOrNull", "onPageCreated", "", "fragment", "onPageScrollStateChanged", "state", "onPageScrolled", "positionOffset", "", "positionOffsetPixels", "onPageSelected", "refresh", "pager_release"})
public class PageAdapter
extends FragmentStatePagerAdapter
implements ViewPager.OnPageChangeListener {
    @NotNull
    private SparseArray<WeakReference<Fragment>> fragments;
    private int currentPosition;
    @NotNull
    private List<? extends PageItem> contents;
    @NotNull
    private IPageCreator creator;

    @NotNull
    protected final SparseArray<WeakReference<Fragment>> getFragments() {
        return this.fragments;
    }

    protected final void setFragments(@NotNull SparseArray<WeakReference<Fragment>> sparseArray) {
        Intrinsics.checkParameterIsNotNull(sparseArray, (String)"<set-?>");
        this.fragments = sparseArray;
    }

    public final int getCurrentPosition() {
        return this.currentPosition;
    }

    protected final void setCurrentPosition(int n) {
        this.currentPosition = n;
    }

    @NotNull
    protected final List<PageItem> getContents() {
        return this.contents;
    }

    protected final void setContents(@NotNull List<? extends PageItem> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.contents = list;
    }

    public final void refresh() {
        this.fragments.clear();
        this.contents = this.creator.getPages();
        this.notifyDataSetChanged();
    }

    @Nullable
    public final Fragment getItemOrNull(int position) {
        WeakReference weakReference = (WeakReference)this.fragments.get(position);
        return weakReference != null ? (Fragment)weakReference.get() : null;
    }

    public int getCount() {
        return this.contents.size();
    }

    @NotNull
    public Fragment getItem(int position) {
        Fragment fragment = this.getItemOrNull(position);
        if (fragment == null) {
            PageAdapter pageAdapter = this;
            boolean bl = false;
            boolean bl2 = false;
            PageAdapter $this$run = pageAdapter;
            boolean bl3 = false;
            Fragment fragment2 = $this$run.contents.get(position).newInstance();
            boolean bl4 = false;
            boolean bl5 = false;
            Fragment fragment3 = fragment2;
            boolean bl6 = false;
            $this$run.fragments.put(position, new WeakReference<Fragment>(fragment3));
            $this$run.onPageCreated(fragment3, position);
            fragment = fragment2;
        }
        return fragment;
    }

    @CallSuper
    protected void onPageCreated(@NotNull Fragment fragment, int position) {
        block2: {
            Fragment fragment2;
            Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
            if (position == this.currentPosition) {
                this.onPageSelected(this.currentPosition);
            }
            if (!((fragment2 = fragment) instanceof IPageStateCallback)) {
                fragment2 = null;
            }
            IPageStateCallback iPageStateCallback = (IPageStateCallback)fragment2;
            if (iPageStateCallback == null) break block2;
            iPageStateCallback.visibilityChanged(position == this.currentPosition);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        if (position != this.currentPosition) {
            Fragment fragment = this.getItemOrNull(this.currentPosition);
            if (!(fragment instanceof IPageStateCallback)) {
                fragment = null;
            }
            IPageStateCallback iPageStateCallback = (IPageStateCallback)fragment;
            if (iPageStateCallback != null) {
                iPageStateCallback.visibilityChanged(false);
            }
        }
        this.currentPosition = position;
        Fragment fragment = this.getItemOrNull(this.currentPosition);
        if (!(fragment instanceof IPageStateCallback)) {
            fragment = null;
        }
        IPageStateCallback iPageStateCallback = (IPageStateCallback)fragment;
        if (iPageStateCallback != null) {
            iPageStateCallback.visibilityChanged(true);
        }
        this.creator.onContentUpdated();
    }

    public void onPageScrollStateChanged(int state) {
    }

    @Nullable
    public final Fragment currentFragment() {
        return this.getItemOrNull(this.currentPosition);
    }

    @NotNull
    protected final IPageCreator getCreator() {
        return this.creator;
    }

    protected final void setCreator(@NotNull IPageCreator iPageCreator) {
        Intrinsics.checkParameterIsNotNull((Object)iPageCreator, (String)"<set-?>");
        this.creator = iPageCreator;
    }

    public PageAdapter(@NotNull FragmentManager fm, @NotNull IPageCreator creator, int initialPosition) {
        Intrinsics.checkParameterIsNotNull((Object)fm, (String)"fm");
        Intrinsics.checkParameterIsNotNull((Object)creator, (String)"creator");
        super(fm, 1);
        this.creator = creator;
        this.fragments = new SparseArray();
        this.currentPosition = initialPosition;
        this.contents = this.creator.getPages();
        this.onPageSelected(initialPosition);
    }

    public /* synthetic */ PageAdapter(FragmentManager fragmentManager, IPageCreator iPageCreator, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = iPageCreator.getDefaultPage();
        }
        this(fragmentManager, iPageCreator, n);
    }
}

