/*
 * Decompiled with CFR 0.152.
 */
package papyrus.pager;

import android.support.v4.view.PagerAdapter;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import java.util.Collection;
import java.util.LinkedList;
import papyrus.util.PapyrusUtil;

public abstract class ViewPagerAdapter<VH extends ViewHolder>
extends PagerAdapter {
    private SparseArray<LinkedList<VH>> viewPool = new SparseArray();

    private VH retreiveViewHolderOfTypeFromPool(int viewType) {
        if (PapyrusUtil.isEmpty((Collection)((Collection)this.viewPool.get(viewType)))) {
            return null;
        }
        return (VH)((ViewHolder)((LinkedList)this.viewPool.get(viewType)).removeFirst());
    }

    private void stashViewHolderForReuse(VH holder) {
        if (this.viewPool.get(((ViewHolder)holder).viewType) == null) {
            this.viewPool.put(((ViewHolder)holder).viewType, new LinkedList());
        }
        ((LinkedList)this.viewPool.get(((ViewHolder)holder).viewType)).push(holder);
    }

    public Object instantiateItem(ViewGroup container, int position) {
        int viewType = this.getItemViewType(position);
        VH holder = this.retreiveViewHolderOfTypeFromPool(viewType);
        if (holder == null) {
            holder = this.onCreateViewHolder(container, viewType);
            ((ViewHolder)holder).viewType = viewType;
        }
        ((ViewHolder)holder).adapterPosition = position;
        this.onBindViewHolder(holder, position);
        container.addView(((ViewHolder)holder).itemView);
        return holder;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        this.onViewRecycled((ViewHolder)object);
        container.removeView(((ViewHolder)object).itemView);
        this.stashViewHolderForReuse((ViewHolder)object);
    }

    public boolean isViewFromObject(View view, Object object) {
        return ((ViewHolder)object).itemView == view;
    }

    public abstract VH onCreateViewHolder(ViewGroup var1, int var2);

    public abstract void onBindViewHolder(VH var1, int var2);

    public void onViewRecycled(VH holder) {
    }

    public int getItemViewType(int position) {
        return 1;
    }

    public static abstract class ViewHolder {
        protected View itemView;
        int viewType = 1;
        int adapterPosition;

        public ViewHolder(View view) {
            this.itemView = view;
        }

        public int getAdapterPosition() {
            return this.adapterPosition;
        }
    }
}

