/*
 * Decompiled with CFR 0.152.
 */
package papyrus.pager;

import android.support.annotation.CallSuper;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.SparseArray;
import java.lang.ref.WeakReference;
import java.util.List;
import papyrus.pager.PageItem;
import papyrus.pager.iface.IPageCreator;
import papyrus.pager.iface.IPageStateCallback;

public class PageAdapter
extends FragmentStatePagerAdapter
implements ViewPager.OnPageChangeListener {
    protected SparseArray<WeakReference<Fragment>> fragments = new SparseArray();
    protected int currentPosition;
    protected IPageCreator creator;
    protected List<PageItem> contents;

    public PageAdapter(FragmentManager fm, IPageCreator creator) {
        this(fm, creator, creator.getDefaultPage());
    }

    public PageAdapter(FragmentManager fm, IPageCreator creator, int initialPosition) {
        super(fm);
        this.creator = creator;
        this.contents = creator.getPages();
        this.currentPosition = initialPosition;
        this.onPageSelected(initialPosition);
    }

    public void refresh() {
        this.fragments.clear();
        this.contents = this.creator.getPages();
        this.notifyDataSetChanged();
    }

    public Fragment getItemOrNull(int position) {
        Fragment fragment;
        WeakReference ref = (WeakReference)this.fragments.get(position);
        if (ref != null && (fragment = (Fragment)ref.get()) != null) {
            return fragment;
        }
        return null;
    }

    public int getCount() {
        return this.contents.size();
    }

    public Fragment getItem(int position) {
        Fragment fragment = this.getItemOrNull(position);
        if (fragment == null) {
            fragment = this.contents.get(position).newInstance();
            this.fragments.put(position, new WeakReference<Fragment>(fragment));
            if (fragment != null) {
                this.onPageCreated(fragment, position);
            }
        }
        return fragment;
    }

    @CallSuper
    protected void onPageCreated(Fragment fragment, int position) {
        if (fragment instanceof IPageStateCallback) {
            if (position == this.currentPosition) {
                this.onPageSelected(this.currentPosition);
            }
            ((IPageStateCallback)fragment).visibilityChanged(position == this.currentPosition);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        Fragment fragment;
        if (position != this.currentPosition && (fragment = this.getItemOrNull(this.currentPosition)) != null && fragment instanceof IPageStateCallback) {
            ((IPageStateCallback)fragment).visibilityChanged(false);
        }
        this.currentPosition = position;
        fragment = this.getItemOrNull(this.currentPosition);
        if (fragment != null && fragment instanceof IPageStateCallback) {
            ((IPageStateCallback)fragment).visibilityChanged(true);
        }
        this.creator.onContentUpdated();
    }

    public void onPageScrollStateChanged(int state) {
    }

    public Fragment currentFragment() {
        return this.getItemOrNull(this.currentPosition);
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }
}

