/*
 * Decompiled with CFR 0.152.
 */
package com.papertrailapp.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import org.productivity.java.syslog4j.SyslogConfigIF;
import org.productivity.java.syslog4j.SyslogIF;
import org.productivity.java.syslog4j.SyslogRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Syslog4jAppender<E>
extends AppenderBase<E> {
    SyslogIF syslog;
    SyslogConfigIF syslogConfig;
    Layout<E> layout;

    protected void append(E loggingEvent) {
        this.syslog.log(this.getSeverityForEvent(loggingEvent), this.layout.doLayout(loggingEvent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        super.start();
        Syslog4jAppender syslog4jAppender = this;
        synchronized (syslog4jAppender) {
            try {
                Class syslogClass = this.syslogConfig.getSyslogClass();
                this.syslog = (SyslogIF)syslogClass.newInstance();
                this.syslog.initialize(syslogClass.getSimpleName(), this.syslogConfig);
            }
            catch (ClassCastException cse) {
                throw new SyslogRuntimeException((Throwable)cse);
            }
            catch (IllegalAccessException iae) {
                throw new SyslogRuntimeException((Throwable)iae);
            }
            catch (InstantiationException ie) {
                throw new SyslogRuntimeException((Throwable)ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        super.stop();
        Syslog4jAppender syslog4jAppender = this;
        synchronized (syslog4jAppender) {
            if (this.syslog != null) {
                this.syslog.shutdown();
                this.syslog = null;
            }
        }
    }

    public int getSeverityForEvent(Object eventObject) {
        if (eventObject instanceof ILoggingEvent) {
            ILoggingEvent event = (ILoggingEvent)eventObject;
            return LevelToSyslogSeverity.convert((ILoggingEvent)event);
        }
        return 6;
    }

    public SyslogConfigIF getSyslogConfig() {
        return this.syslogConfig;
    }

    public void setSyslogConfig(SyslogConfigIF syslogConfig) {
        this.syslogConfig = syslogConfig;
    }

    public Layout<E> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<E> layout) {
        this.layout = layout;
    }
}

