/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.manager;

import com.android.volley.http.HttpEntity;
import com.android.volley.http.MultipartHttpEntity;
import com.android.volley.http.StringHttpEntity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RequestMap {
    private static String ENCODING = "UTF-8";
    protected ConcurrentHashMap<String, String> urlParams;
    protected ConcurrentHashMap<String, FileWrapper> fileParams;

    public RequestMap() {
        this.init();
    }

    public RequestMap(String key, String value) {
        this.init();
        this.put(key, value);
    }

    private void init() {
        this.urlParams = new ConcurrentHashMap();
        this.fileParams = new ConcurrentHashMap();
    }

    public void put(String key, String value) {
        if (key != null && value != null) {
            this.urlParams.put(key, value);
        }
    }

    public void put(String key, File file) {
        try {
            this.put(key, new FileInputStream(file), file.getName());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void put(String key, InputStream stream, String fileName) {
        this.put(key, stream, fileName, null);
    }

    public void put(String key, InputStream stream, String fileName, String contentType) {
        if (key != null && stream != null) {
            this.fileParams.put(key, new FileWrapper(stream, fileName, contentType));
        }
    }

    public String getParamsString(boolean withQuery) {
        if (this.urlParams.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean looped = false;
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            if (looped) {
                sb.append("&");
            } else {
                looped = true;
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
        if (sb.length() > 0) {
            if (withQuery) {
                sb.insert(0, "?");
            }
            return sb.toString();
        }
        return null;
    }

    public HttpEntity getEntity() {
        HttpEntity entity = null;
        if (!this.fileParams.isEmpty()) {
            MultipartHttpEntity multipartEntity = new MultipartHttpEntity();
            for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
                multipartEntity.addPart(entry.getKey(), entry.getValue());
            }
            int currentIndex = 0;
            int lastIndex = this.fileParams.entrySet().size() - 1;
            for (Map.Entry<String, FileWrapper> entry : this.fileParams.entrySet()) {
                FileWrapper file = entry.getValue();
                if (file.inputStream != null) {
                    boolean isLast;
                    boolean bl = isLast = currentIndex == lastIndex;
                    if (file.contentType != null) {
                        multipartEntity.addPart(entry.getKey(), file.getFileName(), file.inputStream, file.contentType, isLast);
                    } else {
                        multipartEntity.addPart(entry.getKey(), file.getFileName(), file.inputStream, isLast);
                    }
                }
                ++currentIndex;
            }
            entity = multipartEntity;
        } else {
            entity = new StringHttpEntity(this.urlParams, ENCODING);
        }
        return entity;
    }

    private static class FileWrapper {
        public InputStream inputStream;
        public String fileName;
        public String contentType;

        public FileWrapper(InputStream inputStream, String fileName, String contentType) {
            this.inputStream = inputStream;
            this.fileName = fileName;
            this.contentType = contentType;
        }

        public String getFileName() {
            if (this.fileName != null) {
                return this.fileName;
            }
            return "nofilename";
        }
    }
}

