/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.http;

import com.android.volley.http.HttpEntity;
import java.util.HashMap;
import java.util.Map;

public class HttpResponse {
    public static final int SC_CONTINUE = 100;
    public static final int SC_OK = 200;
    public static final int SC_NO_CONTENT = 204;
    public static final int SC_MOVED_PERMANENTLY = 301;
    public static final int SC_MOVED_TEMPORARILY = 302;
    public static final int SC_NOT_MODIFIED = 304;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_UNAUTHORIZED = 401;
    private int responseCode;
    private String responseMessage;
    private HttpEntity entityFromConnection;
    private Map<String, String> httpHeaders = new HashMap<String, String>();

    public HttpResponse(int responseCode, String responseMessage) {
        this.setResponseCode(responseCode);
        this.setResponseMessage(responseMessage);
    }

    public void setEntity(HttpEntity entityFromConnection) {
        this.entityFromConnection = entityFromConnection;
    }

    public void addHeader(String key, String value) {
        this.httpHeaders.put(key, value);
    }

    public Map<String, String> getAllHeaders() {
        return this.httpHeaders;
    }

    public HttpEntity getEntity() {
        return this.entityFromConnection;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public boolean isGzipEnable() {
        String acceptEncoding;
        return this.httpHeaders != null && (acceptEncoding = this.httpHeaders.get("Content-Encoding")) != null && acceptEncoding.contains("gzip");
    }
}

