/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.manager;

import android.content.Context;
import com.android.volley.AuthFailureError;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.RequestQueue;
import com.android.volley.manager.ByteArrayLoadController;
import com.android.volley.manager.ByteArrayRequest;
import com.android.volley.manager.LoadController;
import com.android.volley.manager.LoadListener;
import com.android.volley.manager.RequestListenerHolder;
import com.android.volley.manager.RequestMap;
import com.android.volley.toolbox.Volley;
import java.util.HashMap;
import java.util.Map;

public class RequestManager {
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String GZIP = "gzip";
    private static final int TIMEOUT_COUNT = 10000;
    private static final int RETRY_TIMES = 1;
    private static volatile RequestManager INSTANCE = null;
    private RequestQueue mRequestQueue = null;

    private RequestManager() {
    }

    public void init(Context context) {
        this.mRequestQueue = Volley.newRequestQueue(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RequestManager getInstance() {
        if (null != INSTANCE) return INSTANCE;
        Class<RequestManager> clazz = RequestManager.class;
        synchronized (RequestManager.class) {
            if (null != INSTANCE) return INSTANCE;
            INSTANCE = new RequestManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public RequestQueue getRequestQueue() {
        return this.mRequestQueue;
    }

    public LoadController get(String url, RequestListener requestListener, int actionId) {
        return this.get(url, requestListener, true, actionId);
    }

    public LoadController get(String url, RequestListener requestListener, boolean shouldCache, int actionId) {
        return this.request(0, url, null, null, requestListener, shouldCache, 10000, 1, actionId);
    }

    public LoadController post(String url, Object data, RequestListener requestListener, int actionId) {
        return this.post(url, data, requestListener, false, 10000, 1, actionId);
    }

    public LoadController post(String url, Object data, RequestListener requestListener, boolean shouldCache, int timeoutCount, int retryTimes, int actionId) {
        return this.request(1, url, data, null, requestListener, shouldCache, timeoutCount, retryTimes, actionId);
    }

    public LoadController request(int method, String url, Object data, Map<String, String> headers, RequestListener requestListener, boolean shouldCache, int timeoutCount, int retryTimes, int actionId) {
        return this.sendRequest(method, url, data, headers, new RequestListenerHolder(requestListener), shouldCache, timeoutCount, retryTimes, actionId);
    }

    public LoadController sendRequest(int method, String url, Object data, Map<String, String> headers, LoadListener requestListener, boolean shouldCache, int timeoutCount, int retryTimes, int actionId) {
        if (requestListener == null) {
            throw new NullPointerException();
        }
        ByteArrayLoadController loadController = new ByteArrayLoadController(requestListener, actionId);
        ByteArrayRequest request = null;
        if (data != null && data instanceof RequestMap) {
            request = new ByteArrayRequest(1, url, data, loadController, loadController);
            request.setShouldCache(false);
        } else {
            request = new ByteArrayRequest(method, url, data, loadController, loadController);
            request.setShouldCache(shouldCache);
        }
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        if (headers != null && !headers.isEmpty()) {
            requestHeaders.putAll(headers);
        }
        if (requestHeaders.get(ACCEPT_ENCODING) == null) {
            requestHeaders.put(ACCEPT_ENCODING, GZIP);
        }
        try {
            request.getHeaders().putAll(requestHeaders);
        }
        catch (AuthFailureError e) {
            e.printStackTrace();
        }
        DefaultRetryPolicy retryPolicy = new DefaultRetryPolicy(timeoutCount, retryTimes, 1.0f);
        request.setRetryPolicy(retryPolicy);
        loadController.bindRequest(request);
        if (this.mRequestQueue == null) {
            throw new NullPointerException();
        }
        requestListener.onStart();
        this.mRequestQueue.add(request);
        return loadController;
    }

    public static interface RequestListener {
        public void onRequest();

        public void onSuccess(String var1, Map<String, String> var2, String var3, int var4);

        public void onError(String var1, String var2, int var3);
    }
}

