/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.manager;

import android.app.Activity;
import com.android.volley.manager.LoadListener;
import com.android.volley.manager.RequestManager;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.Map;

public class RequestListenerHolder
implements LoadListener {
    private static final String CHARSET_UTF_8 = "UTF-8";
    private WeakReference<RequestManager.RequestListener> mRequestListenerRef;
    private RequestManager.RequestListener mRequestListener;

    public RequestListenerHolder(RequestManager.RequestListener requestListener) {
        if (requestListener instanceof Activity) {
            this.mRequestListenerRef = new WeakReference<RequestManager.RequestListener>(requestListener);
        } else {
            this.mRequestListener = requestListener;
        }
    }

    @Override
    public void onStart() {
        RequestManager.RequestListener requestListener;
        if (this.mRequestListenerRef != null && (requestListener = (RequestManager.RequestListener)this.mRequestListenerRef.get()) != null) {
            requestListener.onRequest();
            return;
        }
        if (this.mRequestListener != null) {
            this.mRequestListener.onRequest();
        }
    }

    @Override
    public void onSuccess(byte[] data, Map<String, String> headers, String url, int actionId) {
        RequestManager.RequestListener requestListener;
        String parsed = null;
        try {
            parsed = new String(data, CHARSET_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (this.mRequestListenerRef != null && (requestListener = (RequestManager.RequestListener)this.mRequestListenerRef.get()) != null) {
            requestListener.onSuccess(parsed, headers, url, actionId);
            return;
        }
        if (this.mRequestListener != null) {
            this.mRequestListener.onSuccess(parsed, headers, url, actionId);
        }
    }

    @Override
    public void onError(String errorMsg, String url, int actionId) {
        RequestManager.RequestListener requestListener;
        if (this.mRequestListenerRef != null && (requestListener = (RequestManager.RequestListener)this.mRequestListenerRef.get()) != null) {
            requestListener.onError(errorMsg, url, actionId);
            return;
        }
        if (this.mRequestListener != null) {
            this.mRequestListener.onError(errorMsg, url, actionId);
        }
    }
}

