/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.http;

import android.text.TextUtils;
import com.android.volley.http.HttpEntity;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StringHttpEntity
extends HttpEntity {
    private static final char NAME_VALUE_CONNECT = '&';
    private static final String NAME_VALUE_SEPARATOR = "=";

    public StringHttpEntity(ConcurrentHashMap<String, String> params, String charsetName) {
        String charset = TextUtils.isEmpty((CharSequence)charsetName) ? DEFAULT_CHARSET : charsetName;
        String contentStr = this.format(params, charset);
        if (contentStr != null) {
            try {
                super.setContent(new ByteArrayInputStream(contentStr.getBytes(charset)));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public String format(ConcurrentHashMap<String, String> params, String charset) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String encodedName = this.encodeFormFields(entry.getKey(), charset);
            String encodedValue = this.encodeFormFields(entry.getValue(), charset);
            if (result.length() > 0) {
                result.append('&');
            }
            result.append(encodedName);
            if (encodedValue == null) continue;
            result.append(NAME_VALUE_SEPARATOR);
            result.append(encodedValue);
        }
        return result.toString();
    }

    @Override
    public String getContentType() {
        return StringHttpEntity.createContentType("application/x-www-form-urlencoded", DEFAULT_CHARSET);
    }

    private String encodeFormFields(String content, String charset) {
        if (content == null) {
            return null;
        }
        try {
            return URLEncoder.encode(content, charset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

