/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.http;

import com.android.volley.http.HttpEntity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;

public class MultipartHttpEntity
extends HttpEntity {
    private static final char[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private String boundary = null;
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    boolean isSetLast = false;
    boolean isSetFirst = false;

    public MultipartHttpEntity() {
        StringBuffer buf = new StringBuffer();
        Random rand = new Random();
        for (int i = 0; i < 30; ++i) {
            buf.append(MULTIPART_CHARS[rand.nextInt(MULTIPART_CHARS.length)]);
        }
        this.boundary = buf.toString();
    }

    @Override
    public String getContentType() {
        return MultipartHttpEntity.createContentType("multipart/form-data", DEFAULT_CHARSET) + "; boundary=" + this.boundary;
    }

    public void writeFirstBoundaryIfNeeds() {
        if (!this.isSetFirst) {
            try {
                this.out.write(("--" + this.boundary + "\r\n").getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.isSetFirst = true;
    }

    public void writeLastBoundaryIfNeeds() {
        if (this.isSetLast) {
            return;
        }
        try {
            this.out.write(("\r\n--" + this.boundary + "--\r\n").getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.isSetLast = true;
    }

    public void addPart(String key, String value) {
        this.writeFirstBoundaryIfNeeds();
        try {
            this.out.write(("Content-Disposition: form-data; name=\"" + key + "\"\r\n\r\n").getBytes());
            this.out.write(value.getBytes());
            this.out.write(("\r\n--" + this.boundary + "\r\n").getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addPart(String key, String fileName, InputStream fin, boolean isLast) {
        this.addPart(key, fileName, fin, "application/octet-stream", isLast);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPart(String key, String fileName, InputStream fin, String type, boolean isLast) {
        this.writeFirstBoundaryIfNeeds();
        try {
            type = "Content-Type: " + type + "\r\n";
            this.out.write(("Content-Disposition: form-data; name=\"" + key + "\"; filename=\"" + fileName + "\"\r\n").getBytes());
            this.out.write(type.getBytes());
            this.out.write("Content-Transfer-Encoding: binary\r\n\r\n".getBytes());
            byte[] tmp = new byte[4096];
            int l = 0;
            while ((l = fin.read(tmp)) != -1) {
                this.out.write(tmp, 0, l);
            }
            if (!isLast) {
                this.out.write(("\r\n--" + this.boundary + "\r\n").getBytes());
            } else {
                this.writeLastBoundaryIfNeeds();
            }
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fin.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void addPart(String key, File value, boolean isLast) {
        try {
            this.addPart(key, value.getName(), new FileInputStream(value), isLast);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public long getContentLength() {
        this.writeLastBoundaryIfNeeds();
        return this.out.toByteArray().length;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        outstream.write(this.out.toByteArray());
    }

    @Override
    public String getContentEncoding() {
        return DEFAULT_CHARSET;
    }

    @Override
    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.out.toByteArray());
    }
}

