/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.manager;

import android.content.Context;
import com.android.volley.AuthFailureError;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.manager.ByteArrayLoadControler;
import com.android.volley.manager.ByteArrayRequest;
import com.android.volley.manager.LoadControler;
import com.android.volley.manager.LoadListener;
import com.android.volley.manager.RequestListenerHolder;
import com.android.volley.manager.RequestMap;
import com.android.volley.toolbox.Volley;
import java.util.Map;

public class RequestManager {
    private static final int TIMEOUT_COUNT = 10000;
    private static final int RETRY_TIMES = 1;
    private static volatile RequestManager INSTANCE = null;
    private RequestQueue mRequestQueue = null;

    private RequestManager() {
    }

    public void init(Context context) {
        this.mRequestQueue = Volley.newRequestQueue(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RequestManager getInstance() {
        if (null != INSTANCE) return INSTANCE;
        Class<RequestManager> clazz = RequestManager.class;
        synchronized (RequestManager.class) {
            if (null != INSTANCE) return INSTANCE;
            INSTANCE = new RequestManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public RequestQueue getRequestQueue() {
        return this.mRequestQueue;
    }

    public LoadControler get(String url, RequestListener requestListener, int actionId) {
        return this.get(url, requestListener, true, actionId);
    }

    public LoadControler get(String url, RequestListener requestListener, boolean shouldCache, int actionId) {
        return this.request(0, url, null, null, requestListener, shouldCache, 10000, 1, actionId);
    }

    public LoadControler post(String url, Object data, RequestListener requestListener, int actionId) {
        return this.post(url, data, requestListener, false, 10000, 1, actionId);
    }

    public LoadControler post(String url, Object data, RequestListener requestListener, boolean shouldCache, int timeoutCount, int retryTimes, int actionId) {
        return this.request(1, url, data, null, requestListener, shouldCache, timeoutCount, retryTimes, actionId);
    }

    public LoadControler request(int method, String url, Object data, Map<String, String> headers, RequestListener requestListener, boolean shouldCache, int timeoutCount, int retryTimes, int actionId) {
        return this.sendRequest(method, url, data, headers, new RequestListenerHolder(requestListener), shouldCache, timeoutCount, retryTimes, actionId);
    }

    public LoadControler sendRequest(int method, String url, Object data, Map<String, String> headers, LoadListener requestListener, boolean shouldCache, int timeoutCount, int retryTimes, int actionId) {
        if (requestListener == null) {
            throw new NullPointerException();
        }
        ByteArrayLoadControler loadControler = new ByteArrayLoadControler(requestListener, actionId);
        ByteArrayRequest request = null;
        if (data != null && data instanceof RequestMap) {
            request = new ByteArrayRequest(1, url, data, loadControler, loadControler);
            request.setShouldCache(false);
        } else {
            request = new ByteArrayRequest(method, url, data, loadControler, loadControler);
            request.setShouldCache(shouldCache);
        }
        if (headers != null && !headers.isEmpty()) {
            try {
                ((Request)request).getHeaders().putAll(headers);
            }
            catch (AuthFailureError e) {
                e.printStackTrace();
            }
        }
        DefaultRetryPolicy retryPolicy = new DefaultRetryPolicy(timeoutCount, retryTimes, 1.0f);
        request.setRetryPolicy(retryPolicy);
        loadControler.bindRequest(request);
        if (this.mRequestQueue == null) {
            throw new NullPointerException();
        }
        requestListener.onStart();
        this.mRequestQueue.add(request);
        return loadControler;
    }

    public static interface RequestListener {
        public void onRequest();

        public void onSuccess(String var1, Map<String, String> var2, String var3, int var4);

        public void onError(String var1, String var2, int var3);
    }
}

