/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.manager;

import com.android.volley.AuthFailureError;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.http.HttpEntity;
import com.android.volley.manager.RequestMap;
import com.android.volley.toolbox.HttpHeaderParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ByteArrayRequest
extends Request<NetworkResponse> {
    private final Response.Listener<NetworkResponse> mListener;
    private Object mPostBody = null;
    private HttpEntity httpEntity = null;

    public ByteArrayRequest(int method, String url, Object postBody, Response.Listener<NetworkResponse> listener, Response.ErrorListener errorListener) {
        super(method, url, errorListener);
        this.mPostBody = postBody;
        this.mListener = listener;
        if (this.mPostBody != null && this.mPostBody instanceof RequestMap) {
            this.httpEntity = ((RequestMap)this.mPostBody).getEntity();
        }
    }

    @Override
    protected Map<String, String> getParams() throws AuthFailureError {
        if (this.httpEntity == null && this.mPostBody != null && this.mPostBody instanceof Map) {
            return (Map)this.mPostBody;
        }
        return null;
    }

    @Override
    public Map<String, String> getHeaders() throws AuthFailureError {
        Map<String, String> headers = super.getHeaders();
        if (null == headers || headers.equals(Collections.emptyMap())) {
            headers = new HashMap<String, String>();
        }
        return headers;
    }

    @Override
    public String getBodyContentType() {
        if (this.httpEntity != null) {
            return this.httpEntity.getContentType();
        }
        return super.getBodyContentType();
    }

    @Override
    public byte[] getBody() throws AuthFailureError {
        if (this.mPostBody != null && this.mPostBody instanceof String) {
            String postString = (String)this.mPostBody;
            if (postString.length() != 0) {
                try {
                    return postString.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            } else {
                return null;
            }
        }
        if (this.httpEntity != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                this.httpEntity.writeTo(baos);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            return baos.toByteArray();
        }
        return super.getBody();
    }

    @Override
    protected Response<NetworkResponse> parseNetworkResponse(NetworkResponse response) {
        return Response.success(response, HttpHeaderParser.parseCacheHeaders(response));
    }

    @Override
    protected void deliverResponse(NetworkResponse response) {
        this.mListener.onResponse(response);
    }
}

