/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.annotations.internal;

import com.palantir.logsafe.Preconditions;
import com.palantir.tritium.annotations.internal.InstrumentedTypeFactory;
import com.palantir.tritium.api.event.InstrumentationFilter;
import com.palantir.tritium.event.CompositeInvocationEventHandler;
import com.palantir.tritium.event.InstrumentationFilters;
import com.palantir.tritium.event.InvocationContext;
import com.palantir.tritium.event.InvocationEventHandler;
import com.palantir.tritium.event.log.LoggingInvocationEventHandler;
import com.palantir.tritium.event.log.LoggingLevel;
import com.palantir.tritium.event.metrics.TaggedMetricsServiceInvocationEventHandler;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import com.palantir.tritium.tracing.TracingInvocationEventHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongPredicate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstrumentationBuilder<T, U extends T> {
    private static final int ESTIMATED_HANDLERS = 4;
    private final Class<? super T> interfaceClass;
    private final T delegate;
    private final InstrumentedTypeFactory<T, U> factory;
    private final List<InvocationEventHandler<InvocationContext>> handlers = new ArrayList<InvocationEventHandler<InvocationContext>>(4);
    private InstrumentationFilter filter = InstrumentationFilters.INSTRUMENT_ALL;

    public InstrumentationBuilder(Class<? super T> interfaceClass, T delegate, InstrumentedTypeFactory<T, U> factory) {
        this.interfaceClass = (Class)Preconditions.checkNotNull(interfaceClass, (String)"class");
        this.factory = (InstrumentedTypeFactory)Preconditions.checkNotNull(factory, (String)"factory");
        this.delegate = Preconditions.checkNotNull(delegate, (String)"delegate");
    }

    public InstrumentationBuilder<T, U> withTaggedMetrics(TaggedMetricRegistry metricRegistry, @Nullable String prefix) {
        Preconditions.checkNotNull((Object)metricRegistry, (String)"metricRegistry");
        String serviceName = prefix == null || prefix.isEmpty() ? this.interfaceClass.getName() : prefix;
        return this.withHandler((InvocationEventHandler<InvocationContext>)new TaggedMetricsServiceInvocationEventHandler(metricRegistry, serviceName));
    }

    public InstrumentationBuilder<T, U> withTaggedMetrics(TaggedMetricRegistry metricRegistry) {
        return this.withTaggedMetrics(metricRegistry, "");
    }

    public InstrumentationBuilder<T, U> withPerformanceTraceLogging() {
        return this.withLogging(InstrumentationBuilder.getPerformanceLoggerForInterface(this.interfaceClass), LoggingLevel.TRACE, (LongPredicate)LoggingInvocationEventHandler.LOG_DURATIONS_GREATER_THAN_1_MICROSECOND);
    }

    private static <T> Logger getPerformanceLoggerForInterface(Class<T> serviceInterface) {
        return LoggerFactory.getLogger((String)("performance." + serviceInterface.getName()));
    }

    public InstrumentationBuilder<T, U> withLogging(Logger logger, LoggingLevel loggingLevel, LongPredicate durationPredicate) {
        return this.withHandler((InvocationEventHandler<InvocationContext>)new LoggingInvocationEventHandler(logger, loggingLevel, durationPredicate));
    }

    public InstrumentationBuilder<T, U> withTracing() {
        return this.withHandler((InvocationEventHandler<InvocationContext>)TracingInvocationEventHandler.create((String)this.interfaceClass.getName()));
    }

    public InstrumentationBuilder<T, U> withHandler(InvocationEventHandler<InvocationContext> handler) {
        Preconditions.checkNotNull(handler, (String)"handler");
        this.handlers.add(handler);
        return this;
    }

    public InstrumentationBuilder<T, U> withHandlers(Iterable<InvocationEventHandler<InvocationContext>> additionalHandlers) {
        Preconditions.checkNotNull(additionalHandlers, (String)"additionalHandlers");
        for (InvocationEventHandler<InvocationContext> handler : additionalHandlers) {
            this.withHandler(handler);
        }
        return this;
    }

    public InstrumentationBuilder<T, U> withFilter(InstrumentationFilter instrumentationFilter) {
        this.filter = (InstrumentationFilter)Preconditions.checkNotNull((Object)instrumentationFilter, (String)"instrumentationFilter");
        return this;
    }

    public U build() {
        return this.factory.create(this.delegate, (InvocationEventHandler<InvocationContext>)CompositeInvocationEventHandler.of(this.handlers), this.filter);
    }

    public static <T, U extends T> U trace(Class<? super T> interfaceClass, T delegate, InstrumentedTypeFactory<T, U> factory) {
        return ((InstrumentedTypeFactory)Preconditions.checkNotNull(factory, (String)"factory")).create(Preconditions.checkNotNull(delegate, (String)"delegate"), (InvocationEventHandler<InvocationContext>)TracingInvocationEventHandler.create((String)((Class)Preconditions.checkNotNull(interfaceClass, (String)"class")).getName()), (InstrumentationFilter)InstrumentationFilters.INSTRUMENT_ALL);
    }
}

