/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.tree.TreeInfo;
import java.io.IOError;
import java.io.IOException;
import javax.lang.model.element.Name;

class Trees {
    Trees() {
    }

    static int getLength(Tree tree, TreePath path) {
        return Trees.getEndPosition(tree, path) - Trees.getStartPosition(tree);
    }

    static int getStartPosition(Tree expression) {
        return ((JCTree)expression).getStartPosition();
    }

    static int getEndPosition(Tree expression, TreePath path) {
        return ((JCTree)expression).getEndPosition(((JCTree.JCCompilationUnit)path.getCompilationUnit()).endPositions);
    }

    static String getSourceForNode(Tree node, TreePath path) {
        CharSequence source;
        try {
            source = path.getCompilationUnit().getSourceFile().getCharContent(false);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return source.subSequence(Trees.getStartPosition(node), Trees.getEndPosition(node, path)).toString();
    }

    static Name getMethodName(MethodInvocationTree methodInvocation) {
        ExpressionTree select = methodInvocation.getMethodSelect();
        return select instanceof MemberSelectTree ? ((MemberSelectTree)select).getIdentifier() : ((IdentifierTree)select).getName();
    }

    static ExpressionTree getMethodReceiver(MethodInvocationTree methodInvocation) {
        ExpressionTree select = methodInvocation.getMethodSelect();
        return select instanceof MemberSelectTree ? ((MemberSelectTree)select).getExpression() : null;
    }

    static String operatorName(ExpressionTree expression) {
        JCTree.Tag tag = ((JCTree)((Object)expression)).getTag();
        if (tag == JCTree.Tag.ASSIGN) {
            return "=";
        }
        boolean assignOp = expression instanceof CompoundAssignmentTree;
        if (assignOp) {
            tag = tag.noAssignOp();
        }
        String name = new Pretty(null, true).operatorName(tag);
        return assignOp ? name + "=" : name;
    }

    static int precedence(ExpressionTree expression) {
        return TreeInfo.opPrec(((JCTree)((Object)expression)).getTag());
    }

    static ClassTree getEnclosingTypeDeclaration(TreePath path) {
        while (path != null) {
            switch (path.getLeaf().getKind()) {
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case ANNOTATED_TYPE: {
                    return (ClassTree)path.getLeaf();
                }
            }
            path = path.getParentPath();
        }
        throw new IllegalStateException();
    }

    static ExpressionTree skipParen(ExpressionTree node) {
        return ((ParenthesizedTree)node).getExpression();
    }
}

