/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.doc;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterators;
import com.google.common.collect.Range;
import com.google.errorprone.annotations.Immutable;
import com.palantir.javaformat.CommentsHelper;
import com.palantir.javaformat.Input;
import com.palantir.javaformat.Newlines;
import com.palantir.javaformat.Op;
import com.palantir.javaformat.Output;
import com.palantir.javaformat.doc.Doc;
import com.palantir.javaformat.doc.DocBuilder;
import com.palantir.javaformat.doc.ImmutableTokState;
import com.palantir.javaformat.doc.Obs;
import com.palantir.javaformat.doc.State;

@Immutable
public final class Comment
extends Doc
implements Op {
    private final Input.Tok tok;

    private Comment(Input.Tok tok) {
        this.tok = tok;
    }

    public static Comment make(Input.Tok tok) {
        return new Comment(tok);
    }

    @Override
    public void add(DocBuilder builder) {
        builder.add(this);
    }

    @Override
    protected float computeWidth() {
        int idx = Newlines.firstBreak(this.tok.getOriginalText());
        if (this.tok.isComment()) {
            if (idx > 0) {
                return idx;
            }
            if (this.tok.isSlashSlashComment() && !this.tok.getOriginalText().startsWith("// ")) {
                return this.tok.length() + 1;
            }
            return this.tok.length();
        }
        return idx != -1 ? Float.POSITIVE_INFINITY : (float)this.tok.length();
    }

    @Override
    protected String computeFlat() {
        if (this.tok.isSlashSlashComment() && !this.tok.getOriginalText().startsWith("// ")) {
            return "// " + this.tok.getOriginalText().substring("//".length());
        }
        return this.tok.getOriginalText();
    }

    @Override
    protected Range<Integer> computeRange() {
        return Range.singleton((Comparable)Integer.valueOf(this.tok.getIndex())).canonical(INTEGERS);
    }

    @Override
    public State computeBreaks(CommentsHelper commentsHelper, int maxWidth, State state, Obs.ExplorationNode observationNode) {
        String text = commentsHelper.rewrite(this.tok, maxWidth, state.column());
        int firstLineLength = text.length() - (Integer)Iterators.getLast(Newlines.lineOffsetIterator(text));
        return state.withColumn(state.column() + firstLineLength).addNewLines(Iterators.size(Newlines.lineOffsetIterator(text))).withTokState(this, ImmutableTokState.of(text));
    }

    @Override
    public void write(State state, Output output) {
        output.append(state, state.getTokText(this), this.range());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tok", (Object)this.tok).toString();
    }
}

