/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.bootstrap;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.javaformat.bootstrap.NativeImageFormatterService;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NativeImageFormatterService.FormatterNativeImageArgs", generator="Immutables")
@Immutable
final class ImmutableFormatterNativeImageArgs
implements NativeImageFormatterService.FormatterNativeImageArgs {
    private final ImmutableList<String> characterRanges;
    private final boolean outputReplacements;
    private final Path nativeImagePath;

    private ImmutableFormatterNativeImageArgs(ImmutableList<String> characterRanges, boolean outputReplacements, Path nativeImagePath) {
        this.characterRanges = characterRanges;
        this.outputReplacements = outputReplacements;
        this.nativeImagePath = nativeImagePath;
    }

    public ImmutableList<String> characterRanges() {
        return this.characterRanges;
    }

    @Override
    public boolean outputReplacements() {
        return this.outputReplacements;
    }

    @Override
    public Path nativeImagePath() {
        return this.nativeImagePath;
    }

    public final ImmutableFormatterNativeImageArgs withCharacterRanges(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableFormatterNativeImageArgs((ImmutableList<String>)newValue, this.outputReplacements, this.nativeImagePath);
    }

    public final ImmutableFormatterNativeImageArgs withCharacterRanges(Iterable<String> elements) {
        if (this.characterRanges == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableFormatterNativeImageArgs((ImmutableList<String>)newValue, this.outputReplacements, this.nativeImagePath);
    }

    public final ImmutableFormatterNativeImageArgs withOutputReplacements(boolean value) {
        if (this.outputReplacements == value) {
            return this;
        }
        return new ImmutableFormatterNativeImageArgs(this.characterRanges, value, this.nativeImagePath);
    }

    public final ImmutableFormatterNativeImageArgs withNativeImagePath(Path value) {
        if (this.nativeImagePath == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "nativeImagePath");
        return new ImmutableFormatterNativeImageArgs(this.characterRanges, this.outputReplacements, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormatterNativeImageArgs && this.equalTo(0, (ImmutableFormatterNativeImageArgs)another);
    }

    private boolean equalTo(int synthetic, ImmutableFormatterNativeImageArgs another) {
        return this.characterRanges.equals(another.characterRanges) && this.outputReplacements == another.outputReplacements && this.nativeImagePath.equals(another.nativeImagePath);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.characterRanges.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.outputReplacements);
        h += (h << 5) + this.nativeImagePath.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FormatterNativeImageArgs").omitNullValues().add("characterRanges", this.characterRanges).add("outputReplacements", this.outputReplacements).add("nativeImagePath", (Object)this.nativeImagePath).toString();
    }

    public static ImmutableFormatterNativeImageArgs copyOf(NativeImageFormatterService.FormatterNativeImageArgs instance) {
        if (instance instanceof ImmutableFormatterNativeImageArgs) {
            return (ImmutableFormatterNativeImageArgs)instance;
        }
        return new NativeImageFormatterService.FormatterNativeImageArgs.Builder().from(instance).build();
    }

    @Generated(from="NativeImageFormatterService.FormatterNativeImageArgs", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_OUTPUT_REPLACEMENTS = 1L;
        private static final long INIT_BIT_NATIVE_IMAGE_PATH = 2L;
        private long initBits = 3L;
        private ImmutableList.Builder<String> characterRanges = ImmutableList.builder();
        private boolean outputReplacements;
        @Nullable
        private Path nativeImagePath;

        public Builder() {
            if (!(this instanceof NativeImageFormatterService.FormatterNativeImageArgs.Builder)) {
                throw new UnsupportedOperationException("Use: new NativeImageFormatterService.FormatterNativeImageArgs.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final NativeImageFormatterService.FormatterNativeImageArgs.Builder from(NativeImageFormatterService.FormatterNativeImageArgs instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllCharacterRanges(instance.characterRanges());
            this.outputReplacements(instance.outputReplacements());
            this.nativeImagePath(instance.nativeImagePath());
            return (NativeImageFormatterService.FormatterNativeImageArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NativeImageFormatterService.FormatterNativeImageArgs.Builder addCharacterRanges(String element) {
            this.characterRanges.add((Object)element);
            return (NativeImageFormatterService.FormatterNativeImageArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NativeImageFormatterService.FormatterNativeImageArgs.Builder addCharacterRanges(String ... elements) {
            this.characterRanges.add((Object[])elements);
            return (NativeImageFormatterService.FormatterNativeImageArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NativeImageFormatterService.FormatterNativeImageArgs.Builder characterRanges(Iterable<String> elements) {
            this.characterRanges = ImmutableList.builder();
            return this.addAllCharacterRanges(elements);
        }

        @CanIgnoreReturnValue
        public final NativeImageFormatterService.FormatterNativeImageArgs.Builder addAllCharacterRanges(Iterable<String> elements) {
            this.characterRanges.addAll(elements);
            return (NativeImageFormatterService.FormatterNativeImageArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NativeImageFormatterService.FormatterNativeImageArgs.Builder outputReplacements(boolean outputReplacements) {
            this.outputReplacements = outputReplacements;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (NativeImageFormatterService.FormatterNativeImageArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NativeImageFormatterService.FormatterNativeImageArgs.Builder nativeImagePath(Path nativeImagePath) {
            this.nativeImagePath = Objects.requireNonNull(nativeImagePath, "nativeImagePath");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (NativeImageFormatterService.FormatterNativeImageArgs.Builder)this;
        }

        public ImmutableFormatterNativeImageArgs build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFormatterNativeImageArgs((ImmutableList<String>)this.characterRanges.build(), this.outputReplacements, this.nativeImagePath);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("outputReplacements");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("nativeImagePath");
            }
            return "Cannot build FormatterNativeImageArgs, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

