/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.spotless.FormatterStep;
import com.palantir.javaformat.gradle.JavaFormatExtension;
import com.palantir.javaformat.gradle.NativeImageFormatProviderPlugin;
import com.palantir.javaformat.gradle.spotless.NativePalantirJavaFormatStep;
import com.palantir.javaformat.gradle.spotless.PalantirJavaFormatStep;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

final class SpotlessInterop {
    private static Logger logger = Logging.getLogger(SpotlessInterop.class);

    private SpotlessInterop() {
    }

    static void addSpotlessJavaStep(Project project) {
        SpotlessExtension spotlessExtension = (SpotlessExtension)project.getExtensions().getByType(SpotlessExtension.class);
        spotlessExtension.java(java -> java.addStep(SpotlessInterop.addSpotlessJavaFormatStep(project)));
    }

    static FormatterStep addSpotlessJavaFormatStep(Project project) {
        if (NativeImageFormatProviderPlugin.isNativeImageConfigured(project) && JavaVersion.current().compareTo((Enum)JavaVersion.VERSION_21) < 0) {
            logger.info("Using the native-image formatter");
            return NativePalantirJavaFormatStep.create(project.getRootProject().getConfigurations().getByName("palantirJavaFormatNative"));
        }
        logger.info("Using the Java-based formatter {}", (Object)JavaVersion.current());
        return PalantirJavaFormatStep.create(project.getRootProject().getConfigurations().getByName("palantirJavaFormat"), (JavaFormatExtension)project.getRootProject().getExtensions().getByType(JavaFormatExtension.class));
    }
}

