/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import java.util.Iterator;
import java.util.NoSuchElementException;

final class LineOffsetIterator
implements Iterator<Integer> {
    private int curr = 0;
    private int idx = 0;
    private final String input;

    public LineOffsetIterator(String input) {
        this.input = input;
    }

    @Override
    public boolean hasNext() {
        return this.curr != -1;
    }

    @Override
    public Integer next() {
        if (this.curr == -1) {
            throw new NoSuchElementException();
        }
        int result = this.curr;
        this.advance();
        return result;
    }

    private void advance() {
        while (this.idx < this.input.length()) {
            char c = this.input.charAt(this.idx);
            switch (c) {
                case '\r': {
                    if (this.idx + 1 < this.input.length() && this.input.charAt(this.idx + 1) == '\n') {
                        ++this.idx;
                    }
                }
                case '\n': {
                    ++this.idx;
                    this.curr = this.idx;
                    return;
                }
            }
            ++this.idx;
        }
        this.curr = -1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

