/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.gitversion;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.palantir.gradle.gitversion.GitDescribe;
import com.palantir.gradle.gitversion.GitUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NativeGitDescribe
implements GitDescribe {
    private static final Logger log = LoggerFactory.getLogger(NativeGitDescribe.class);
    private static final Splitter LINE_SPLITTER = Splitter.on((String)System.getProperty("line.separator")).omitEmptyStrings();
    private static final Splitter WORD_SPLITTER = Splitter.on((String)" ").omitEmptyStrings();
    private final File directory;

    NativeGitDescribe(File directory) {
        this.directory = directory;
    }

    private String runGitCmd(String ... commands) throws IOException, InterruptedException {
        ArrayList<String> cmdInput = new ArrayList<String>();
        cmdInput.add("git");
        cmdInput.addAll(Arrays.asList(commands));
        ProcessBuilder pb = new ProcessBuilder(cmdInput);
        pb.directory(this.directory);
        pb.redirectErrorStream(true);
        Process process = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        StringBuilder builder = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            builder.append(line);
            builder.append(System.getProperty("line.separator"));
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            return "";
        }
        return builder.toString().trim();
    }

    @Override
    public String describe(String prefix) {
        if (!this.gitCommandExists()) {
            return null;
        }
        try {
            HashSet<String> tagRefs = new HashSet<String>();
            for (String tag : LINE_SPLITTER.splitToList((CharSequence)this.runGitCmd("show-ref", "--tags", "-d"))) {
                List parts = WORD_SPLITTER.splitToList((CharSequence)tag);
                Preconditions.checkArgument((parts.size() == 2 ? 1 : 0) != 0, (String)"Could not parse output of `git show-ref`: %s", (Object)parts);
                tagRefs.add((String)parts.get(0));
            }
            List revs = LINE_SPLITTER.splitToList((CharSequence)this.runGitCmd("rev-list", "--first-parent", "HEAD"));
            for (int depth = 0; depth < revs.size(); ++depth) {
                String exactTag;
                String rev = (String)revs.get(depth);
                if (!tagRefs.contains(rev) || (exactTag = this.runGitCmd("describe", "--tags", "--exact-match", "--match=" + prefix + "*", rev)).isEmpty()) continue;
                return depth == 0 ? exactTag : String.format("%s-%s-g%s", exactTag, depth, GitUtils.abbrevHash((String)revs.get(0)));
            }
            return GitUtils.abbrevHash(this.runGitCmd("rev-parse", "HEAD"));
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            log.debug("Native git describe failed: {}", (Throwable)e);
            return null;
        }
    }

    private boolean gitCommandExists() {
        try {
            Process gitVersionProcess = new ProcessBuilder("git", "version").start();
            if (gitVersionProcess.waitFor() != 0) {
                throw new IllegalStateException("error invoking git command");
            }
            return true;
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            log.debug("Native git command not found: {}", (Throwable)e);
            return false;
        }
    }
}

