/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins.javaversions;

import com.palantir.baseline.plugins.javaversions.BaselineJavaCompiler;
import com.palantir.baseline.plugins.javaversions.BaselineJavaLauncher;
import com.palantir.baseline.plugins.javaversions.BaselineJavaToolchain;
import com.palantir.baseline.plugins.javaversions.BaselineJavadocTool;
import com.palantir.baseline.plugins.javaversions.BaselineJavadocToolAdapter;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.jvm.toolchain.JavaCompiler;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavadocTool;

final class ConfiguredJavaToolchain
implements BaselineJavaToolchain {
    private final ObjectFactory objectFactory;
    private final Provider<JavaInstallationMetadata> javaInstallationMetadata;

    ConfiguredJavaToolchain(ObjectFactory objectFactory, Provider<JavaInstallationMetadata> javaInstallationMetadata) {
        this.objectFactory = objectFactory;
        this.javaInstallationMetadata = javaInstallationMetadata;
    }

    @Override
    public Provider<JavaCompiler> javaCompiler() {
        return this.javaInstallationMetadata.map(metadata -> BaselineJavaCompiler.create(this.objectFactory, metadata));
    }

    @Override
    public Provider<JavadocTool> javadocTool() {
        return this.javaInstallationMetadata.map(BaselineJavadocTool::new).map(javadocTool -> BaselineJavadocToolAdapter.create(this.objectFactory, javadocTool));
    }

    @Override
    public Provider<JavaLauncher> javaLauncher() {
        return this.javaInstallationMetadata.map(BaselineJavaLauncher::new);
    }
}

